/**
 * 绘制图形
 *
 * @example
 * DrawGeometry.draw({
 *          type:'polygon',//绘制样式，目前有点(point)线(line)面(polygon)
 *          measureType:'measureArea',//测量内容，目前有测长度(measureLength)和测面积(measureArea)两种，不设置值时为绘制图形并返回
 *          measureUnit: config[0].config.areaUnit//测量单位 目前只有面积有，分别是：平方米，平方千米，亩，公顷，在tpl中配置
 *          fun: 默认为空，当有需要在双击结束之后进行的事件将事件写入,可以写一个getGeo来获得图形数据，再回到自己的方法中
 *          })
 * 例子
 * DrawGeometry.draw({
 *      type:'polygon',
 *      fun:getGeo
 *      })
 *
 * function getGeo(geo){
 *
 *  }
 * 获得数据
 * DrawGeometry.drawResult
 *
 */
define(['easyMap/main', 'leaflet', 'popup'], function (MainMap, L, Popup) {
    var $map;
    var geomService;
    //默认坐标系
    var defaultCrs = JSON.stringify({"wkid": 4610, "latestWkid": 4610});
    //实时添加的
    var drawLayer = [];
    //删除用的全部的图层
    var drawLayers = [];
    // 传递出featureService结构信息
    var geoMessage = "";
    //图形的点位置信息
    var clickPoints = [];
    //绘制类型
    var drawType = '';
    //控制多余一次的鼠标移动事件
    var controlMouseMove = false;
    //起始点
    var startPoint = '';
    //默认平方千米
    var areaUnit = 1000000;
    //默认千米
    var lengthUnit = 1000;
    //图形的点的CircleLayer
    var pointMakerLayer = [];
    var pointMakerLayers = [];
    //鼠标移动中生成的图层
    var mouseLyrs = [];
    //弹出窗
    var popups = [];
    var measurePopups = [];
    //用来记录方便删除的图层数组
    var measureLayers = [];
    //用来记录方便删除的图层ID
    var id;
    var popupOptions = {
        maxWidth: 200,
        minWidth: 25,
        closeOnClick: false,
        closeButton: false
    };

    ////////////////
    //draw polygon
    var tempLines = new L.polyline([], {dashArray: 5});
    var points = [];
    var lines = new L.polyline([]);
    var polygon2 = [];
    ////////////////////

    var trigger = null;
    // 生成线时样式
    var finishLineStyle = {color: '#f90303', weight: '2', lineCap: 'round', fillColor: '#f90303', fillOpacity: 0.3};
    // 面的样式
    var polygonStyle = {color: '#f90303', weight: '2', dashArray: '4', fillColor: '#f90303', fillOpacity: 0.3};
    // 圆圈的样式
    var circleStyle = {
        color: '#f90303',
        opacity: 0.5,
        fillColor: '#FFF',
        weight: '2',
        fillOpacity: 1,
        pane: 'markerPane',
        radius: 4.5
    };

    var drawGeometry = {
        //默认不进入测量方法
        measureLength: false,
        measureArea: false,
        measurePoint: false,
        //绘制图层结果
        drawResult: {},
        //是否进入鼠标移动和双击的监听
        isActive: false,
        //控制测量面积的单位,默认平方千米
        measureUnit: '平方千米',
        //是否实时计算
        measureAtOnce: true,

        //默认初始化，防止报错
        fun: function (drawLayer) {
            $map = MainMap.map.get$Map();
            geomService = MainMap.appConfig.interface.geometryService;
        },

        draw: function (drawGeo,baseMap,url) {
            $map= baseMap;
            geomService = url;
            drawType = drawGeo.type;
            //如果不为空，更新方法
            this.fun = drawGeo.fun;
            if (drawGeo.hasOwnProperty('measureUnit')) {
                this.measureUnit = drawGeo.measureUnit;
            }
            if (this.measureUnit === '平方千米' || this.measureUnit === '平方公里') {
                areaUnit = 1000000;
            } else if (this.measureUnit === '公顷') {
                areaUnit = 10000;
            } else if (this.measureUnit === '亩') {
                areaUnit = 2000 / 3;
            } else if (this.measureUnit === '平方米') {
                areaUnit = 1;
            } else if (this.measureUnit === '米') {
                lengthUnit = 1;
            } else if (this.measureUnit === '千米' || this.measureUnit === '公里') {
                lengthUnit = 1000;
            } else if (this.measureUnit === '英尺') {
                lengthUnit = 0.3048;
            } else if (this.measureUnit === '英里') {
                lengthUnit = 1609.344;
            }
            if (drawGeo.measureType === 'measureLength') {
                this.measureLength = true;
            } else if (drawGeo.measureType === 'measureArea') {
                this.measureArea = true;
            } else if (drawGeo.measureType === 'measurePoint') {
                this.measurePoint = true;
            }
            if (drawGeo.measureAtOnce !== undefined) {
                this.measureAtOnce = drawGeo.measureAtOnce;
            }

            // 添加鼠标自定义样式
            L.DomUtil.addClass($map._container, 'draw-cursor-enabled');

            switch (drawType) {
                case 'point':
                    this.drawPoint();
                    $map.doubleClickZoom.disable();
                    break;
                case 'line':
                    this.drawEvent();
                    if (this.measureLength === false) {
                        this.doClear();
                    }
                    $map.doubleClickZoom.disable();
                    break;
                case 'polygon':
                    this.drawEvent();
                    if (this.measureArea === false) {
                        this.doClear();
                    }
                    $map.doubleClickZoom.disable();
                    break;
                case 'polygon2':
                    this.drawEvent();
                    if (this.measureArea === false) {
                        this.doClear();
                    }
                    $map.doubleClickZoom.disable();
            }
        },
        //监听点击事件画点
        drawPoint: function () {
            $map.on('click', this.pointMapEventHandler, this);
        },
        //监听地图的点击，双击，移动事件来绘制线面
        drawEvent: function () {
            id = 'line_' + Math.random() * 100;
            $map.on('click dblclick mousemove mouseover', this.mapEventHandler, this);
        },
        //画点功能
        pointMapEventHandler: function (e) {
            this.doClear();
            drawLayer = L.circleMarker(e.latlng, circleStyle);
            this.getDrawLayer();
            this.disableLayerClick(drawLayer);
            drawLayers.push(drawLayer);
            drawLayer.addTo($map);
            if (this.measurePoint === false) {
                $map.off('click', this.pointMapEventHandler, this);
            }
        },
        mapEventHandler: function (e) {
            var eType = e.type;
            switch (eType) {
                case 'click':
                    this._mouseClick(e);
                    this.isActive = true;
                    break;
                case 'dblclick':
                    if (this.isActive === true) {
                        this._mouseDblclick(e);
                    }
                    break;
                case 'mousemove':
                    this._mouseMove(e);
                    break;
                default:
                    return;
            }
        },
        //鼠标单击事件
        _mouseClick: function (e) {
            var linePoint = [];
            //获取点位生成记录点
            startPoint = e.latlng;
            var pointMakerLayer = L.circleMarker(startPoint, circleStyle);
            this.disableLayerClick(pointMakerLayer);
            //记录点ID，方便删除
            pointMakerLayers.push({id: id, pointMakerLayer: pointMakerLayer});
            //将点放入集合中，方便统一清空
            clickPoints.push(startPoint);
            //获取上一个点，这样画线的时候不会将之前的线叠加
            var previousPoint = clickPoints[Object.keys(clickPoints)[Object.keys(clickPoints).length - 2]];
            if (clickPoints.length > 1) {
                linePoint = [startPoint, previousPoint];
            } else {
                linePoint = [startPoint];
            }
            if (drawType === 'polygon2') {
                ////////////////////
                //绘制组成线的面
                //points.push([e.latlng.lat,e.latlng.lng]);
                points.push(e.latlng);
                lines.addLatLng(e.latlng);
                $map.addLayer(tempLines);
                $map.addLayer(lines);
                //////////////////////////
            }
            if (drawType === 'line') {
                //生成线图层
                drawLayer = L.polyline(linePoint, finishLineStyle);
                drawLayer.addTo($map);
                measureLayers.push({id: id, layers: drawLayer});
                if (this.measureLength === true && this.measureAtOnce) {
                    var lengthsValue = '';
                    if (clickPoints.length === 1) {
                        lengthsValue = '起点';
                        //设置pop窗的偏移
                        var offset = L.point(30, 13);
                    } else {
                        var line = [{"paths": [this.getAgsPoints(clickPoints)]}];
                        lengthsValue = this.getLengths(line);
                        lengthsValue = (lengthsValue / lengthUnit).toFixed(2) + this.measureUnit;
                        var offset = L.point(40, 13);
                    }
                    var htmlText = '<div class="draw-measure-pop"> <span>' + lengthsValue + '</span> </div>';
                    //增加测量的弹出框
                    popupOptions.offset = offset;
                    var pop = L.popup(popupOptions);
                    this.addPopup(pop, e.latlng, htmlText);
                } else {
                    drawGeometry.mouseMoveWithoutMeasure(e);
                }
            } else if (drawType === 'polygon' && clickPoints.length > 2) {
                //trigger = setTimeout(function () {
                drawLayer = L.polygon(clickPoints, polygonStyle);
                // });
            }
            pointMakerLayer.addTo($map);
        },
        //鼠标移动提示框及拖动效果
        _mouseMove: function (e) {
            //激活状态进入绘画样式的事件，非激活状态进入鼠标移动提示事件
            if (this.isActive) {
                clearTimeout(trigger);
                var mousePoint = e.latlng;
                if (mouseLyrs.length === 1) {
                    //移除上一个图层
                    $map.removeLayer(mouseLyrs[0]);
                    mouseLyrs = [];
                }
                if (drawType === 'line') {
                    var mouseLine = L.polyline([startPoint, mousePoint], finishLineStyle);
                    //关闭图层点击事件
                    this.disableLayerClick(mouseLine);
                    mouseLyrs.push(mouseLine);
                    mouseLine.addTo($map);
                } else if (drawType === 'polygon') {
                    clickPoints.push(mousePoint);
                    var polygon = L.polygon(clickPoints, polygonStyle);
                    this.disableLayerClick(polygon);
                    mouseLyrs.push(polygon);
                    polygon.addTo($map);
                    clickPoints.pop();

                } else if (drawType === 'polygon2') {
                    if (points.length > 0) {
                        var ls = [points[points.length - 1], [e.latlng.lat, e.latlng.lng], points[0]];
                        tempLines.setLatLngs(ls);
                        this.disableLayerClick(tempLines);
                        // map.addLayer(tempLines)
                    }
                }
                //如果实时计算则增加弹出窗，若不进行实时计算就不增加弹出窗
                if (this.measureAtOnce) {
                    //增加
                    trigger = setTimeout(function () {
                        if (drawType === 'line') {
                            if (drawGeometry.measureLength !== false) {
                                clickPoints.push(mousePoint);
                                var line = [{"paths": [drawGeometry.getAgsPoints(clickPoints)]}];
                                var lineLengths = drawGeometry.getLengths(line);
                                //在默认值为0的时候不展示，顺便解决谷歌会多跑一次setTimeout的问题
                                if (lineLengths !== 0) {
                                    lineLengths = (lineLengths / lengthUnit).toFixed(2) + drawGeometry.measureUnit;
                                    drawGeometry.mouseMovePop(lineLengths, e);
                                } else {
                                    if (!controlMouseMove) {
                                        drawGeometry.mouseMoveStartPop(e);
                                    }
                                }
                                clickPoints.pop();
                            }
                        } else if (drawType === 'polygon') {
                            if (drawGeometry.measureArea === true) {
                                clickPoints.push(mousePoint);
                                var polygonPoints = [{"rings": [drawGeometry.getAgsPoints(clickPoints)]}];
                                var polygonValue = drawGeometry.getAreas(polygonPoints);
                                if (polygonValue !== 0) {
                                    polygonValue = (polygonValue / areaUnit).toFixed(2) + drawGeometry.measureUnit;
                                    drawGeometry.mouseMovePop(polygonValue, e);
                                } else {
                                    if (!controlMouseMove) {
                                        drawGeometry.mouseMoveStartPop(e);
                                    }
                                }
                                clickPoints.pop();
                            }
                        }
                    }, 100);
                } else {
                    drawGeometry.mouseMoveWithoutMeasure(e);
                }
            } else {
                drawGeometry.mouseMoveStartPop(e);
            }
        },

        _mouseDblclick: function (e) {
            if (drawType === 'polygon2') {
                ///////////////////////
                //组成面
                //删除双击多出的点
                points.pop();
                if (points.length > 2) {
                    var thisLyr = L.polygon(points).addTo($map);
                    polygon2.push(thisLyr);
                } else {
                    Popup.msg({
                        message: "请绘制面状图形",
                        type: error,
                        duration: 3000
                    });
                    $map.removeLayer(drawLayer);
                    drawGeometry.clearLayerById(id);
                }
                this.getAreaTip(points, thisLyr);
                //初始化
                points = [];
                lines.remove();
                tempLines.remove();
                lines = new L.polyline([]);
                tempLines = new L.polyline([], {dashArray: 5});
                ////////////////////////////////////////////
            }
            //去除一个多余的marker点
            $map.removeLayer(pointMakerLayer);
            $("#mouseMovePop").css("display", "none");
            clickPoints.pop();
            drawLayer = L.polygon(clickPoints, polygonStyle);
            if (drawType === 'polygon') {
                if (this.measureArea === true) {
                    //包含双击点击两次产生的多于的点，如果只绘制了一条线的话就移除图层并提示重新绘制
                    if (clickPoints.length <= 2) {
                        Popup.msg({
                            message: "请绘制面状图形",
                            type: error,
                            duration: 3000
                        });
                        $map.removeLayer(drawLayer);
                        drawGeometry.clearLayerById(id);
                        clickPoints = [];
                    } else {
                        geoMessage = drawLayer.toGeoJSON();
                        drawLayer.addTo($map);
                        this.getAreaTip(clickPoints, drawLayer);
                    }
                }
            } else if (drawType === 'line') {
                //因为之前是一段一段生成的线，所以这里将重新生成一段线，返回一条完整的线数据
                drawLayer = L.polyline(clickPoints, finishLineStyle);
                if (this.measureLength === true) {
                    var lineValue = '';
                    if (clickPoints.length === 1) {
                        lineValue = '起点';
                        var offset = L.point(30, 13);
                    } else {
                        var line = [{"paths": [this.getAgsPoints(clickPoints)]}];
                        lineValue = this.getLengths(line);
                        lineValue = (lineValue / lengthUnit).toFixed(2) + this.measureUnit;
                        var offset = L.point(68, 13);
                    }
                    var htmlText = '<div class="draw-measure-pop"> <span>总长：' + lineValue + '</span> ' +
                        '<span class="icon-f-analysis-delete measure-close-icon" id = "' + id +
                        '"></span></div>';
                    //增加测量的弹出框
                    popupOptions.offset = offset;
                    var pop = L.popup(popupOptions);
                    this.addPopup(pop, e.latlng, htmlText);
                }
            }

            // 移除鼠标样式
            var crosshair = L.DomUtil.hasClass($map._container, 'draw-cursor-enabled');
            if (crosshair) {
                L.DomUtil.removeClass($map._container, 'draw-cursor-enabled');
            }

            //删除按钮
            $('.measure-close-icon').on('click', function () {
                var clearId = this.id;
                drawGeometry.clearLayerById(clearId);
            });
            if (mouseLyrs.length > 0) {
                $map.removeLayer(mouseLyrs[0]);
                mouseLyrs = [];
                clickPoints = [];
                startPoint = '';
            }
            //获取绘制图层属性
            this.getDrawLayer();
            //控制多余的一次鼠标移动事件
            controlMouseMove = true;
            drawLayers.push(drawLayer);
            this.isActive = false;
            $map.off('click dblclick mousemove', this.mapEventHandler, this);
            $map.doubleClickZoom.enable();
            if (this.fun !== undefined) {
                this.fun(drawLayer);
            }
            return false;
        },
        //地图切换关闭事件的接口
        close: function () {
            $map.off('click dblclick mousemove', this.mapEventHandler, this);
            $map.off('click', this.pointMapEventHandler, this);
            measureLayers.forEach(function (measureLayer) {
                $map.removeLayer(measureLayer.layers);
            });

            var crosshair = L.DomUtil.hasClass($map._container, 'draw-cursor-enabled');
            if (crosshair) {
                L.DomUtil.removeClass($map._container, 'draw-cursor-enabled');
            }

            this.doClear();
        },

        //清除按钮，清除地图上所有内容
        doClear: function () {
            if (drawLayers.length > 0) {
                drawLayers.forEach(function (layer) {
                    $map.removeLayer(layer);
                })
            }
            if (pointMakerLayers.length > 0) {
                pointMakerLayers.forEach(function (pointMakerLayer) {
                    $map.removeLayer(pointMakerLayer.pointMakerLayer);
                })
            }
            if (drawType === 'polygon' && mouseLyrs.length !== 0) {
                $map.removeLayer(mouseLyrs[0]);
            }
            if (popups.length > 0) {
                popups.forEach(function (popup) {
                    popup._close();
                });
                popups = [];
            }
            if (measureLayers.length > 0) {
                measureLayers.forEach(function (measureLayer) {
                    $map.removeLayer(measureLayer.layers);
                });
            }
            drawLayers = [];
            mouseLyrs = [];
            pointMakerLayers = [];
            $.each(polygon2, function (i, pLayer) {
                $map.removeLayer(pLayer);
            });
            polygon2 = [];
            clickPoints = [];
        },
        //获取绘制图层
        getDrawLayer: function () {
            this.drawResult = {};
            this.drawResult = drawLayer;
        },
        //使图层不可点击
        disableLayerClick: function (layer) {
            layer.options.interactive = false;
        },
        // 拼装ags点的值
        getAgsPoints: function (val) {
            var arr = [];
            val.forEach(function (latlng) {
                arr.push([latlng.lng, latlng.lat]);
            });
            return arr;
        },
        //获取线长度
        getLengths: function (line) {
            var linkUrl = geomService + '/lengths?';
            var lengths = '';
            var polylines = JSON.stringify(line);
            linkUrl = linkUrl + 'sr=' + defaultCrs + '&polylines=' + polylines + '&geodesic=true&lengthUnit=9001&f=json';
            linkUrl = encodeURI(linkUrl);

            //根据url读取查询数据
            $.support.cors = true;
            $.ajaxSettings.async = false;
            $.getJSON(linkUrl).done(function (data) {
                lengths = data.lengths[0];
            });
            return lengths;
        },
        //获得面积
        getAreas: function (area) {
            var linkUrl = geomService + '/areasAndLengths?';
            var polygonArea = '';
            var polygons = JSON.stringify(area);
            linkUrl = linkUrl + 'sr=' + defaultCrs + '&polygons=' + polygons + '&geodesic=true&lengthUnit=9001&f=json&calculationType=preserveShape&areaUnit={"areaUnit": "esriSquareMeters"}';
            linkUrl = encodeURI(linkUrl);
            $.support.cors = true;
            $.ajaxSettings.async = false;
            $.getJSON(linkUrl).done(function (data) {
                polygonArea = data.areas[0]
            });
            return polygonArea;
        },
        //鼠标移动弹窗
        mouseMovePop: function (val, e) {
            var htmlContent = '<div class="measure-mouse-pop">' +
                '<div>' + val + '</div>' +
                '<div class="measure-pop-text">单击确定地点, 双击结束</div>' +
                '</div>';
            var moveX = e.containerPoint.x + 5;
            //这里是容器坐标，所以额外+97
            var moveY = e.containerPoint.y + 102;
            $("#mouseMovePop").html(htmlContent);
            $("#mouseMovePop").css("left", moveX + "px").css("top", moveY + "px").css("display", "");
            $('.leaflet-popup-tip-container').css('display', 'none');
        },
        //进入绘制事件后，鼠标未点击前的pop提示
        mouseMoveStartPop: function (e) {
            var htmlContent = '<div class="measure-mouse-pop">' +
                '<div class="measure-pop-text">单击确定地点, 双击结束</div>' +
                '</div>';
            var moveX = e.containerPoint.x + 5;
            //这里是容器坐标，所以额外+97
            var moveY = e.containerPoint.y + 102;
            $("#mouseMovePop").html(htmlContent);
            $("#mouseMovePop").css("left", moveX + "px").css("top", moveY + "px").css("display", "");
            $('.leaflet-popup-tip-container').css('display', 'none');
        },

        //不进行实时计算的鼠标pop提示
        mouseMoveWithoutMeasure: function (e) {
            var htmlContent = '<div class="measure-mouse-pop">' +
                '<div class="measure-pop-text">双击结束</div>' +
                '</div>';
            var moveX = e.containerPoint.x + 5;
            //这里是容器坐标，所以额外+97
            var moveY = e.containerPoint.y + 102;
            $("#mouseMovePop").html(htmlContent);
            $("#mouseMovePop").css("left", moveX + "px").css("top", moveY + "px").css("display", "");
            $('.leaflet-popup-tip-container').css('display', 'none');
        },
        //根据ID删除测量绘制图层
        clearLayerById: function (clearId) {
            measureLayers.forEach(function (measureLayer) {
                if (measureLayer.id === clearId) {
                    $map.removeLayer(measureLayer.layers)
                }
            });
            pointMakerLayers.forEach(function (pointMakerLayer) {
                if (pointMakerLayer.id === clearId) {
                    $map.removeLayer(pointMakerLayer.pointMakerLayer);
                }
            });
            measurePopups.forEach(function (measurePopup) {
                if (measurePopup.id === clearId) {
                    measurePopup.popup._close();
                }
            })
        },
        //增加弹窗
        addPopup: function (pop, latlng, content) {
            pop.setLatLng(latlng);
            pop.setContent(content);
            pop.addTo($map);
            popups.push(pop);
            measurePopups.push({id: id, popup: pop});
            $('.leaflet-popup-tip-container').css('display', 'none');
        },
        //测面弹窗
        getAreaTip: function (Point, Lyr) {
            var polygonPoints = [{"rings": [this.getAgsPoints(Point)]}];
            var polygonValue = this.getAreas(polygonPoints, id);
            polygonValue = (polygonValue / areaUnit).toFixed(2) + this.measureUnit;
            var htmlText = '<div class="draw-measure-pop"> <span>总面积：' + polygonValue + '</span>' +
                '<span class="icon-f-analysis-delete measure-close-icon" id = "' + id +
                '"></span></div>';
            //获取中心点，获得popup弹出位置
            var bounds = Lyr.getBounds();
            var centerPoint = bounds.getCenter();
            var pop = L.popup(popupOptions);
            this.addPopup(pop, centerPoint, htmlText);
            measureLayers.push({id: id, layers: Lyr});
        }
    };

    return drawGeometry;
});
