/**
 * 图层切换
 * viewmodel
 * @author by <a href="mailto:xxx@gmail.com">cyj</a>
 * @version v1.0 2019  Copyright gtmap Corp
 */
define([
    "knockout"
],function (
    ko) {

    var LISTEN = [];// 监听事件
    var ViewModel = function () {
        this.showService = ko.observable(false);// 控制可见性
        this.layers = ko.observableArray([]);// 控制图层数组
    };

    ViewModel.prototype = {

        /**
         * 点击切换图层
         * @param btn
         * @param event
         * @returns {boolean}
         */
        changeLyr: function (btn,event) {
            var that = this;
            try {
                // 触发监听事件
                $.each(LISTEN, function (i, e) {
                    e(btn);
                });

            }catch(e){console.log(e)}

            return true;
        },

        /**
         * 增加监听事件
         * @param event
         */
        addEventListener: function (event) {
            LISTEN.push(event);
        },

        /**
         * 移除监听事件
         * @param event
         */
        removeEventListener: function (event) {
            LISTEN.splice($.inArray(event,LISTEN),1);
        },

        /**
         * 折叠
         * @param btn
         * @param event
         */
        foldMenu: function (btn,event) {
            var dom = $(event.target);
            if(dom.hasClass("layui-icon-triangle-d")){
                dom.removeClass("layui-icon-triangle-d").addClass("layui-icon-triangle-r");
                $(".layers-node").slideUp(200);
            }else {
                dom.removeClass("layui-icon-triangle-r").addClass("layui-icon-triangle-d");
                $(".layers-node").slideDown(200);
            }
        }
    };

    return new ViewModel;
});