/**
 * 渲染图例
 *
 * @author by <a href="mailto:xxx@gmail.com">cyj</a>
 * @version v1.0 2019  Copyright gtmap Corp
 */

define([
    'knockout',
    'popup'
], function (
    ko,
    Popup
) {
   var  element;
    layui.use('element', function(){
        element = layui.element;
        element.render();
    });
    function ViewModel() {
        this.legendList = ko.observableArray([]);
        this.showLegend = ko.observable(false);
        this.legendTitle = ko.observable("");
    }

    ViewModel.prototype= {
        /**
         * 展开
         * @param btn
         * @param event
         */
        showbody: function (btn, event) {
            var dom = $(event.target);
            if(dom.hasClass("layui-icon-up")){
                dom.removeClass("layui-icon-up").addClass("layui-icon-down");
                dom.parent().css('width','210px');
                $('.legend-body').show("slow");
            }else {
                dom.removeClass("layui-icon-down").addClass("layui-icon-up");
                dom.parent().css('width','80px');
                $('.legend-body').hide("slow");
            }
        },

        /**
         * 根据地址读取属性
         * @param url
         */
        init: function (layer) {

            element.render();
            // layer.url ="http://172.16.96.85:8090/iserver/services/map-GTKJGH_JQXZYD/rest/maps/GTKJGH_JQXZYD";
            readLegend(layer,this)
        }
    };

    function readLegend(layer,self) {
        var that = self;
        $.support.cors = true;
        if(layer.label||layer.alias){
            that.legendTitle (layer.label||layer.alias);
        }
        if(layer.url.indexOf("iserver")!=-1){
            SMapLegendContent(layer,self);
            return;
        }
        $.ajax({
            url: layer.url + '/legend',
            type: 'get',
            dataType: 'jsonp',
            data: {f: 'pjson'},
            success: function (data, status) {
                if (status === 'success') {

                    var result = data.layers;

                    var LendLayerArr = selectLendLayer(layer,result);

                    $.each(LendLayerArr,function (i,e) {
                        if(e==undefined){
                            return;
                        }
                        e.url = layer.url;
                    });
                    that.legendList(LendLayerArr);

                    //  $.each(result,function (i,e) {
                    //      e.url = layer.url;
                    //  });
                    // that.legendList(result);
                    element.render();
                }
            }
        });
    }

    function SMapLegendContent(option,self) {
        var that = self;
        var lyrName="";
        $.support.cors = true;
        $.ajax({
            url: option.url + '/layers.rjson',
            type: 'get',
            // dataType: 'jsonp',
            success: function (data, status) {
                if(status!="success"){
                    Popup.msg('获取图例失败，请联系管理员！');
                    return;
                }
                if(typeof data=="string"){
                    data=JSON.parse(data);
                }
                // label,icon
                var legends = getAllLegends(data,"",option.url);
                that.legendList(legends);
                element.render();
            },
            error: function (e) {
                Popup.msg('获取图例失败，请联系管理员！');
            }
        });
    }
    /**
     * 获取所有图例
     */
    function getAllLegends(layers,legendLayerName,url){
        if(layers.length==0){
            return layers;
        }
        var resultLayers =[];
        $(layers).map(function (i,layer) {
            layer.name= layer.name.replace("#",".");
            if(legendLayerName){
                legendLayerName=layer.name +"@@"+legendLayerName;
            }else {
                legendLayerName=layer.name;
            }
            if(layer.subLayers&&layer.subLayers.layers){
                resultLayers= resultLayers.concat(getAllLegends(layer.subLayers.layers,legendLayerName,url));
            }else {
                //叶节点
                //对layer参数进行处理
                //获取图层多图例
                if(layer.theme&&layer.theme.items){
                    //
                    $(layer.theme.items).map(function (i,item) {
                        var result ={};
                        result.label = item.caption;
                        result.url =url+"/layers/"+legendLayerName+"/items/"+i+"/legend";
                        result.isSM=true;//超圖
                        resultLayers.push(result);
                    })
                }

            }
        })
        return resultLayers;
    }

    /**
     * 过滤 展示的图列
     * @param layer
     * @param result
     * @returns {*}
     */
    function selectLendLayer(layer,result){
        if(!result){
            return;
        }
        var layerArr = [];
        var selectLayerArr = layer.legendLayer;
        if(selectLayerArr.length > 0){

            for(var i=0;i<selectLayerArr.length;i++){

                if(selectLayerArr[i] !=undefined && parseFloat(selectLayerArr[i]).toString() != "NaN"){

                    if(selectLayerArr[i]<=result.length){
                        var j = selectLayerArr[i];
                        layerArr.push(result[j]);
                    }
                }
            }
        }
        if(layerArr.length == 0){
            return result;
        }else{
            return layerArr;
        }


    }

    return new ViewModel;
});