/**
 * 公共脚本（模块化）
 * @author 杨红杰
 * @date 2018-11-21
 */
layui.define(['layer', 'laydate'], function(exports){
    var $ = layui.$, laydate = layui.laydate, layer = layui.layer;

    var common = {
        msg: {
            CZCG: '操作成功！',
            CZSB: '操作失败！',
            QXZ: '请选择！',
            QRCZ: '确认该操作吗？'
        },
        /**
         * 获取最外层layer
         * @param obj
         * @returns {*}
         */
        getTopLayer: function(obj) {
            if (obj === undefined) {
                obj = self;
            }
            if (obj === top || obj.parent.layui === undefined || obj.parent.layui.layer === undefined) {
                return obj.layui.layer;
            }
            return this.getTopLayer(obj.parent);
        },
        /**
         * 格式化数字
         * @param value
         * @param num 保留小数位，当要整数时该值可以不传
         * @param sfbl 是否补0，不需要补0可以不传
         * @returns {*}
         */
        formatNum: function(value, num, sfbl) {
            if($.trim(value) == "" || isNaN(value)){
                return 0;
            }

            var n = 0;
            if($.trim(num) != "" && !isNaN(num) && parseInt(num) > 0 && parseInt(num) <= 20){
                n = parseInt(num);
            }

            var v = parseFloat(value);
            v = v.toFixed(n);

            if($.trim(sfbl) != "true") {
                return parseFloat(v);
            }
            return v;
        },
        /**
         * 询问框
         * @param msg 消息
         * @param callback 确认回调事件
         * @param cancel 取消回调事件
         */
        confirm: function(msg, callback, cancel) {
            if ($.trim(msg) == "") {
                msg = "　";
            }

            layer.confirm(msg, {icon: 3, title:'提示'}, function(index){
                if(typeof callback == "function") {
                    callback();
                }
                layer.close(index);
            }, function(){
                if(typeof cancel == "function") {
                    cancel();
                    layer.close(index);
                }
            });
        },
        /**
         * 在当前Iframe的父页面弹出询问框
         * @param msg 消息
         * @param callback 确认回调事件
         * @param cancel 取消回调事件
         */
        confirmOnParentIframe: function(msg, callback, cancel) {
            if ($.trim(msg) == "") {
                msg = "　";
            }
            parent.layer.confirm(msg, {icon: 3, title:'提示'}, function(index){
                if(typeof callback == "function") {
                    callback();
                }
                layer.close(index);
            }, function(){
                if(typeof cancel == "function") {
                    cancel();
                    layer.close(index);
                }
            });
        },
        /**
         * 弹框
         * @param url
         * @param width
         * @param height
         * @param title 标题
         * @param maxmin 默认true，最大化按钮
         */
        open: function(url, width, height, title, maxmin){
            /*var selfFrame = self.frameElement;
            if (selfFrame !== null) {
                if (selfFrame.getAttribute('id') === null)  {
                    selfFrame.setAttribute('id', "layui-layer-iframe-1")
                }
                if ($.trim(url) != "") {
                    if (url.indexOf("?") != -1) {
                        url += "&";
                    } else {
                        url += "?";
                    }
                    url += "layerId=" + selfFrame.getAttribute('id');
                }
            }*/

            if(!width){
                width = $(window).width() * 0.9;
            }
            if(!height){
                height = $(window).height() * 0.9;
            }
            if(!title){
                title = '　';
            }
            if($.trim(maxmin) == ""){
                maxmin = true;
            }
            var loadedForIE=0;
            layer.open({
                type: 2,
                title: title,
                fix: false,
                shadeClose: true,
                maxmin: maxmin,
                area: [width + 'px', height + 'px'],
                content: url,
                success:function(r){
                    if(!$.support.opacity && loadedForIE === 0){
                        var id = $(r.selector + " .layui-layer-content iframe").attr("name");
                        document.getElementById(id).contentWindow.location.reload(true);
                        loadedForIE =1;
                    }
                }
            });
        },
        /**
         * 在当前Iframe的父页面弹框
         * @param url
         * @param width
         * @param height
         * @param title 标题
         * @param maxmin 默认true，最大化按钮
         */
        openOnParentIframe: function(url, width, height, title, maxmin){
            if(!width){
                width = $(window).width() * 0.9;
            }
            if(!height){
                height = $(window).height() * 0.9;
            }
            if(!title){
                title = '　';
            }
            if($.trim(maxmin) == ""){
                maxmin = true;
            }
            var loadedForIE=0;
            parent.layer.open({
                type: 2,
                title: title,
                fix: false,
                shadeClose: true,
                maxmin: maxmin,
                area: [width + 'px', height + 'px'],
                content: url,
                success:function(r){
                    if(!$.support.opacity && loadedForIE === 0){
                        var id = $(r.selector + " .layui-layer-content iframe").attr("name");
                        document.getElementById(id).contentWindow.location.reload(true);
                        loadedForIE =1;
                    }
                }
            });
        },
        /**
         * 打开新窗口
         * @param url
         * @param width
         * @param height
         * @param resizable
         */
        openUrl: function (url, width, height, resizable) {
            if (url) {
                var w_width = screen.availWidth - 14;
                var w_height = screen.availHeight - 66;
                var left = 0;
                var top = 0;
                if (width) {
                    w_width = width;
                    left = (screen.availWidth - w_width) / 2;
                }
                if (height) {
                    w_height = height;
                    top = (screen.availHeight - w_height) / 2;
                }
                if (!resizable) {
                    resizable = "yes";
                }
                window.open(url, "_blank", "left=" + left + ",top=" + top + ",height=" + w_height + ",width=" + w_width + ",resizable=" + resizable + ",scrollbars=yes");
            }
        },
        /**
         * layer 弹出窗口关闭
         */
        close: function() {
            var curindex = layer.getFrameIndex(window.name); //先得到当前iframe层的索引
            layer.close(curindex);
        },
        /**
         * 刷新layer弹窗父页面
         */
        /*parentReload: function() {
            if (layerId !== "") {
                var frame = $("#" + layerId , parent.document);
                if (frame.attr("src") === undefined) {
                    parent.location.reload();
                } else {
                    frame.attr("src", frame.attr("src"));
                    this.close();
                }
            } else {
                parent.location.reload();
            }
        },*/
        /**
         * 消息框
         * @param msg 支持字符串和json
         * @param reload 是否刷新
         * @param func 回调函数
         * @param icon 图标
         */
        alert: function(msg, reload, func, icon) {
            var _msg = "　";
            var _icon = 7;

            if("string" != typeof msg){
                if(msg.result == false){
                    _icon = 2;
                } else {
                    _icon = 1;
                }
                if(msg.msg){
                    _msg = msg.msg;
                }
            } else {
                _msg = msg;
            }

            if ($.trim(icon) != "" && formatNum(icon) >= 0 && formatNum(icon) <= 7) {
                _icon = formatNum(icon);
            }

            layer.alert(_msg, {icon: _icon});
            $(".layui-layer-close").remove();
            if (reload == true) {
                $(".layui-layer-btn0").click(function(){
                    location.reload();
                });
            } else {
                $(".layui-layer-btn0").click(function(){
                    if ($.trim(func) != "") {
                        try{
                            eval(func);
                        }catch(e){}
                    }
                });
            }
        },
        /**
         * 在当前iframe的父页面弹出消息框
         * @param msg 支持字符串和json
         * @param reload 是否刷新
         * @param func 回调函数
         * @param icon 图标
         */
        alertOnParentIframe: function(msg, reload, func, icon) {
            var _msg = "　";
            var _icon = 7;

            if("string" != typeof msg){
                if(msg.result == false){
                    _icon = 2;
                } else {
                    _icon = 1;
                }
                if(msg.msg){
                    _msg = msg.msg;
                }
            } else {
                _msg = msg;
            }

            if ($.trim(icon) != "" && formatNum(icon) >= 0 && formatNum(icon) <= 7) {
                _icon = formatNum(icon);
            }

            parent.layer.alert(_msg, {icon: _icon});
            $(".layui-layer-close").remove();
            if (reload == true) {
                $(".layui-layer-btn0").click(function(){
                    parent.location.reload();
                });
            } else {
                $(".layui-layer-btn0").click(function(){
                    if ($.trim(func) != "") {
                        try{
                            eval(func);
                        }catch(e){}
                    }
                });
            }
        },
        /**
         * 给表格单元格添加提示
         */
        addTitle: function() {
            $(".layui-table .layui-table-cell").each(function(){
                var reg = new RegExp("<.+>");
                if($(this).html().match(reg) === null) {
                    $(this).attr("title", $(this).html());
                }
            });
        },
        /**
         * 获取url参数
         * @param name 参数名
         * @returns {*}
         */
        getQueryString: function (name) {
            var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)");
            var r = location.search.substr(1).match(reg);
            if (r != null) return unescape(r[2]);
            return null;
        },
        /**
         * 给查询表单添加事件
         * @param id
         * @param callback
         */
        addSearchEvent: function(id, callback) {
            if ($(id).length > 0 && typeof callback == "function") {
                $(id).bind("keypress", function (e) {
                    var keynum;
                    if (window.event) {//IE浏览器下的事件
                        keynum = e.keyCode;
                    } else {//非IE浏览器下的事件
                        keynum = e.which;
                    }
                    if (keynum == 13) {
                        e.preventDefault();
                        callback();
                    }
                });
                $(id + " dd").click(function(){
                    callback();
                });
            }
        },
        /**
         * 校验数字
         */
        checkNumber: function() {
            $(".digits,.number0").keyup(function(){
                $(this).val($(this).val().replace(/[^\d]/g,''));
            });
            $(".digits,.number0").blur(function(){
                $(this).val($(this).val().replace(/[^\d]/g,''));
            });
            $(".number,.number2,.number4,.number5").keyup(function(){
                $(this).val($(this).val().replace(/[^\d.]/g,''));
            });
            $(".number,.number2,.number4,.number5").blur(function(){
                $(this).val($(this).val().replace(/[^\d.]/g,''));
            });
        },
        /**
         * 0显示为空
         */
        clearZero: function () {
            /*$.each($("input.layui-input"), function(){
                if (($.trim($(this).attr("type")) == "" || $(this).attr("type").indexOf("text") != -1) && $(this).val() == 0) {
                    $(this).val("");
                }
            });
            $.each($("td"), function(){
                if ($(this).html() == 0) {
                    $(this).html("");
                }
            });*/
        },
        /**
         * 帆软编码转换
         * @param text
         * @returns {string}
         */
        cjkEncode: function(text) {
            if (text == null) {
                return "";
            }
            var newText = "";
            for (var i = 0; i < text.length; i++) {
                var code = text.charCodeAt (i);
                if (code >= 128 || code == 91 || code == 93) {//91 is "[", 93 is "]".
                    newText += "[" + code.toString(16) + "]";
                } else {
                    newText += text.charAt(i);
                }
            }
            return newText;
        },
        /**
         * 帆软打印
         * @param path
         */
        frPrint: function(path) {
            if($.trim(path) != "") {
                var id = "fr_iframe";
                var iframe = $("#" + id);
                if (iframe.length === 0) {
                    iframe = document.createElement("iframe");
                    iframe.id = id;
                    iframe.width = 0;
                    iframe.height = 0;
                    iframe.src = reportUrl + "/ReportServer?reportlet=" + path + "&initprint=true";
                    document.body.appendChild(iframe);
                } else {
                    iframe.attr("src", iframe.attr("src"));
                }
            }
        },
        /**
         * 帆软导出word
         * @param path
         */
        frExportWord: function(path) {
            if($.trim(path) != "") {
                location.href = reportUrl + "/ReportServer?reportlet=" + path + "&format=word";
            }
        },
        /**
         * 帆软导出excel
         * @param path
         */
        frExportExcel: function(path) {
            if($.trim(path) != "") {
                location.href = reportUrl + "/ReportServer?reportlet=" + path + "&format=excel&extype=simple";
            }
        },
        /**
         * 合并表格中的单元格
         * @param $rows 表格中的所有行对象
         * @param startIndex 从第几列开始处理
         * @param total 需要处理的列数
         * 调用方式：
         groupTable($('#test tr:has(td)'), 0, 4);
         $('#test .deleted').remove();
         *  引用网址：http://techbrij.com/html-table-row-grouping-jquery
         */
        groupTableTdInput : function ($rows, startIndex, total) {
            if (total === 0) {
                return;
            }
            var i, currentIndex = startIndex, count = 1, lst = [];
            var tds = $rows.find('td:eq(' + currentIndex + ')');//获取当前列号的所有列集合（该列的所有td）
            var ctrl = $(tds[0]);//获取列集合的第一个列td（第一次执行则是第一个td数据）
            lst.push($rows[0]);//将该td所在行放入数组（第一次执行则是第一行数据）
            //遍历该列集合
            for (i = 1; i <= tds.length; i++) {
                if (!ctrl.html()){
                    ctrl.html('<label>&nbsp</label>');
                }
                if (!$(tds[i]).html()){
                    $(tds[i]).html('<label>&nbsp</label>');
                }
                if (ctrl.html() && ctrl.html() == $(tds[i]).html()) {
                    //如果上一个td内容等于当前td内容，则count加1，
                    //且当前td增加deleted样式进行标识（用于后期删除使用）
                    //将该td所在行放入数组
                    count++;
                    $(tds[i]).addClass('deleted');
                    lst.push($rows[i]);
                } else {
                    //如果上一个td内容不等于当前td内容，则进行如下判断和操作：
                    //如果count大于1，则表示有相同的td需要合并，
                    //对该td的rowspan赋值，值为需要合并的行数
                    //此时递归调用该方法，对之前合并单元格所涉及到的行数据进行处理（用于处理后面列的td合并）
                    //处理方式是当前列后面一列进行操作，total减少一个（当前操作的列）直至total为0
                    if (count > 1) {
                        ctrl.attr('rowspan', count);
                        //ctrl.css("vertical-align","middle");
                        //ctrl.css("text-align","center");
                        common.groupTableTdInput($(lst), startIndex + 1, total - 1)
                    }
                    //将count初始化为1
                    //数据初始为空
                    //td初始化为当前td
                    //将该td所在行放入数组
                    count = 1;
                    lst = [];
                    ctrl = $(tds[i]);
                    lst.push($rows[i]);
                }
                //$(tds[i]).css("text-align","center");
                //$(tds[i]).css("vertical-align","middle");
            }
        },
        /**
         * 用于layui table插入行
         * @param layId
         * @returns {Array}
         */
        getLayuiTableData: function(layId) {
            var data = [];
            $.each($("div[lay-id='" + layId + "'] .layui-table-body tr"), function() {
                var field = {};
                $.each($(this).find("*[field]"), function() {
                    field[$(this).attr("field")] = $(this).val();
                });
                data.push(field);
            });
            return data;
        },
        openWorkflow: function(taskData) {
            this.openUrl(bpmUiUrl + "/task/" + taskData.taskId + "/openFormPage?processInstanceId=" + taskData.processInstanceId + "&formKey=" + taskData.formKey + "&state=" + taskData.state + "&claimStatus=" + taskData.claimStatus + "&processInstanceName=" + encodeURI(taskData.processInstanceName) + "&disable=false")
            this.close();
        },
        /**
         * -------------------------------------------------------------------------------------------------------------
         * 检查组件的【必选】配置项是否为空
         * @param config(object)  组件配置
         * @param mustItem(Array)   必选项
         * -------------------------------------------------------------------------------------------------------------
         */
        checkConfigIsEmpty: function (plugin, mustItem) {
            if (plugin.config === undefined || plugin.config === null) {
                return;
            }
            var item, checkLength;
            $.each(plugin.config, function (index, obj) {
                for (var i = 0; i < mustItem.length; i++) {
                    checkLength = false;
                    item = mustItem[i];
                    if (item.indexOf('.length') > 0) {
                        item = item.substr(0, item.indexOf('.length'));
                        checkLength = true;
                    }
                    if (item === index) {
                        if (obj === undefined || obj === null) {
                            exception.throwNotFindConfig(plugin, item);
                            return;
                        }
                        if (checkLength && checkLength <= 0) {
                            exception.throwNotFindConfig(plugin, item);
                            return;
                        }
                    }
                }
            })
        },


        /**
         * ----------------------------------------------------------------------------------
         * 将组件配置中的字符串或对象封装成容器并检查合法性
         * @param that
         * @returns {*}
         * ----------------------------------------------------------------------------------
         */
        getContainer: function (that) {
            var _config = that.config;
            //如果没有配置容器则,使用默认容器
            if (_config.el === undefined || _config.el === null) {
                _config.el = that.info.el;
            }
            if (typeof (_config.el) !== 'string' && typeof (_config.el) !== 'object') {
                exception.throwElemConfigError(that);
                return null;
            }
            var $container;
            if (typeof (_config.el) === 'string') {
                $container = $('' + _config.el + '');
            }
            if (typeof (_config.el) === 'object') {
                $container = _config.el;
            }
            if ($container != null && $container != undefined && $container.length === 0) {
                exception.throwElemNotFind(that.info);
                return null;
            }
            return $container;
        },
        /**----------------------------------------------------------------------------------
         * 获取当前项目的根路径
         * 返回:http:www.example.cn:port/工程名
         * @returns {string}
         * -----------------------------------------------------------------------------------
         */
        getRootPath: function () {
            var curWwwPath = window.document.location.href;
            var pathName = window.document.location.pathname;
            var pos = curWwwPath.indexOf(pathName);
            var localhostPaht = curWwwPath.substring(0, pos);
            var projectName = pathName.substring(0, pathName.substr(1).indexOf('/') + 1);
            return (localhostPaht + projectName);
        },
        getServerUrl: function () {
            var curWwwPath = window.document.location.href;
            var pathName = window.document.location.pathname;
            var pos = curWwwPath.indexOf(pathName);
            var localhostPath = curWwwPath.substring(0, pos);
            return localhostPath;
        },
        getUrlParam: function () {
            var url = decodeURI(location.href);
            var str = url.substr(url.indexOf("param=") + 6, url.length);
            return JSON.parse(str);
        },
        //下载的公共方法
        downloadURL: function (url) {
            var hiddenIFrameID = 'hiddenDownloader';
            var iframe = document.getElementById(hiddenIFrameID);
            if (iframe === null) {
                iframe = document.createElement('iframe');
                iframe.id = hiddenIFrameID;
                iframe.style.display = 'none';
                document.body.appendChild(iframe);
            }
            iframe.src = url;
        }
    };

    // 给jquery定义方法
    (function($){
        /**
         * 将form表单转化为Json
         */
        $.fn.serializeJson=function(){
            var serializeObj={};
            var array=this.serializeArray();
            var str=this.serialize();
            $(array).each(function(){
                if(serializeObj[this.name]){
                    if($.isArray(serializeObj[this.name])){
                        serializeObj[this.name].push(this.value);
                    }else{
                        serializeObj[this.name]=[serializeObj[this.name],this.value];
                    }
                }else{
                    serializeObj[this.name]=this.value;
                }
            });
            return serializeObj;
        };
        /**
         * 将form表单转化为Json字符串
         */
        $.fn.serializeJsonStr=function(){
            return JSON.stringify(this.serializeJson());
        }
    })($);

    var otherHeight = 73;
    $(function() {
        gtInit();

        $(window).resize(function() {
            gtInit();
        });
    });

    function gtInit() {
        $(".gt-content,.gt-min-h").css("min-height", $(window).height() - otherHeight);

        $(".gt-head").removeAttr("style");
        if ($(".gt-head").width() > $(window).width()) {
            $(".gt-head").width($(window).width() - 50);
        }

        common.checkNumber();
    }

    setTimeout(function() {
        $(".layui-date").each(function() {
            laydate.render({
                elem: this //指定元素
            });
        });
    }, 100);

    exports('common', common);
});

/**
 * 隐藏显示滚动条
 * @param d
 */
function showScroll($scroll,isScroll) {

    $scroll.style.overflowY="hidden";

    if(isScroll){

        var timer = null;

        $scroll.onmouseover = function(){

            if(timer) clearTimeout(timer);
            $scroll.style.overflowY="scroll";
            $scroll.scrollWidth= 6;
        }
        $scroll.onmouseout = function(){
            timer = setTimeout(function(){
                $scroll.style.overflowY="hidden";
            },400);
        }
    }
}

/**
 * 判断是否有滚动条
 * @returns {boolean}
 */
function hasScrollbar($scroll) {

    return $scroll.scrollHeight > (window.innerHeight || document.documentElement.clientHeight);
}

/**
 * 设置右侧指标项标题和数值
 *
 */
function setRightData(base,params,zbxType) {

    var status,titleAry=[];

    //获取当前年份某一地区的指标值
    var maeValues = getMaeValues(base,params);
    $(".nf").html("年份 (" + params.nf + ")");
    maeValues.forEach(function (value,index) {
        var zbTitle = value.name;
        titleAry.push(zbTitle);
        if( zbxType == "population"){

            if(index == 1){
                index += 1;
            }else if(index == 2){
                index -= 1;
            }
        }
        $("#" + zbxType + index).html(zbTitle);

        if(zbxType == "jsyd" && index == maeValues.length-1){
            $("#jsyd" + (index+1)).html(titleAry[0] + "变化情况");
        }

        var unit = value.unit;
        var checkrule = value.checkrule;
        var planvalue = parseInt(value.planvalue);
        var calcuvalue = parseInt(value.calcuvalue);

        if(!isNaN(planvalue) && !isNaN(calcuvalue)){

            //下线控制
            if(checkrule == "xxkz"){

                if(calcuvalue < planvalue){
                    status = "预警";
                }else{
                    status = "健康";
                }
            }else{

                if(calcuvalue > planvalue){
                    status = "预警";
                }else{
                    status = "健康";
                }
            }
        }else if(!isNaN(planvalue) && isNaN(calcuvalue)){
            status = "健康";
        }else{
            status = "";
        }

        $(".status" + index).html(status);
        $(".unit" + index).html(unit);
        $(".jcxz" + index).html(calcuvalue == "null" ? "" : calcuvalue);
        $(".ghmbn" + index).html(planvalue == "null" ? "" : planvalue);


        if(status == "健康"){
            $(".jcxz" + index).removeClass("content-text-red");
            $(".jcxz" + index).addClass("content-text-blue");
            $(".status" + index).removeClass("red-tip");
            $(".status" + index).addClass("blue-tip");
        }else{
            $(".jcxz" + index).removeClass("content-text-blue");
            $(".jcxz" + index).addClass("content-text-red");
            $(".status" + index).removeClass("blue-tip");
            $(".status" + index).addClass("red-tip");
        }
    });

    return titleAry;
}


/**
 * 设置右侧指标数据
 */
function setRightZbData(base,params,zbxType,name){
    var jsonAry=[],liHtml = "",itemHtml = "",echartHtml = "";
    $("#" + zbxType + "-content-body").empty();
    //获取当前年份某一地区的指标值
    var maeValues = getMaeValues(base,params);
    // var yearHtml = '<div class="content-text-align nf"><span>年份：'+ params.nf +'</span></div>';
    var yearHtml = '<div class="content-text-align nf"><span class="region-name jcyj-region" style="font-size: 16px"></span>' +
        '<div id="statusId" class="" style="height: 18px;width: 65px;float: right;text-align: center;line-height: 18px;font-size: 16px;margin-top: 12px"></div></div>';
    $("#" + zbxType + "-content-body").append(yearHtml);



    if(!isEmpty(name)){
        if(name.length > 11){
            $('#title').html(name.substr(0,12)+'...');
        }else {
            $('#title').html(name);
        }
        $('#title').attr("title",name);
    }
    maeValues.forEach(function (value,index) {
        var showinmap = value.showinmap;
        //去除在地图上展示的指标值
        if( showinmap != "1"){
            var jsonObj = {};
            var zbTitle = value.name;
            var statusId = value.statusId;
            var jcxzId = value.jcxzId;
            var ghmbnId = value.ghmbnId;
            var checkrule = value.checkrule;
            var planvalue = (value.planvalue == null )? "-" : parseFloat(value.planvalue).toFixed(2)/1;//除1去掉小数点后的00
            var calcuvalue = (value.calcuvalue == null)? "-" : parseFloat(value.calcuvalue).toFixed(2)/1;
            var plannearvalue = (value.plannearvalue == null)  ? "-" : parseFloat(value.plannearvalue).toFixed(2)/1;
            var mildvalue = value.mildvalue == null ? 0.6 : value.mildvalue;
            var severevalue = value.severevalue == null ? 0.8 : value.severevalue;

            var unit = value.unit;
            //var average = (parseFloat(planvalue)+parseFloat(calcuvalue))/2;
            //var mbValue = isNaN(average) ? 2888 : average.toFixed(2);

            $("#xzqdm-itemName").html("各地区"+zbTitle+"实施情况");

            //图表展示类型
            var echartype = value.echartype;
            var html = '<div class="content-header header-height'+index+'">' +
                '<div><i class="iconfont icon-data_icon9"></i>' +
                '<span class="content-header-text ml10">'+zbTitle+' ('+ unit+')</span></div></div>' +
                '<div class="count"><div id="'+statusId+'" class="top">' +
                '<div class="tip"></div><div class="line"></div>' +
                '<div class="year"><div id="'+jcxzId+'" class="i-box"><img src="">' +
                '<i class="iconfont"></i></div><p>'+ params.nf +'</p></div>' +
                '<div class="year"><div class="i-box"><img src="static/image/monitorWarning/1.png">' +
                '<i class="iconfont icon-shuju1"></i></div><p>2025</p></div>' +
                '<div class="year"><div class="i-box"><img src="static/image/monitorWarning/1.png">' +
                '<i class="iconfont icon-shuju1"></i></div><p>2035</p></div></div>' +
                '<div class="bottom">' +
                '<div id="'+ghmbnId+'" class="">'+calcuvalue+'</div><div class="">'+plannearvalue+'</div><div class="">'+planvalue+'</div></div></div>';

            $("#" + zbxType + "-content-body").append(html);

            planvalue = parseFloat(value.planvalue);
            calcuvalue = parseFloat(value.calcuvalue);
            mildvalue = parseFloat(mildvalue);
            severevalue = parseFloat(severevalue);
            if(!isEmpty(value.planvalue) && !isEmpty(value.planvalue)){

                var mildValue = planvalue*mildvalue;
                var severeValue = planvalue*severevalue;

                //下线控制
                if(checkrule == "xxkz"){

                    if(calcuvalue > severeValue){
                        status = "健康";
                    }else if(calcuvalue >= mildValue && calcuvalue <= severeValue){
                        status = "轻度预警";
                    }else{
                        status = "严重预警";
                    }
                }else{
                    if(calcuvalue > severeValue){
                        status = "严重预警";
                    }else if(calcuvalue >= mildValue && calcuvalue <= severeValue){
                        status = "轻度预警";
                    }else{
                        status = "健康";
                    }

                }
            }else{
                status = "健康";
            }
            $("#" + statusId + " .tip").html(status);

            //将显示“健康”、“轻度预警”、“严重预警”的按钮 显示在上面
            $("#statusId").addClass(statusId);
            $("." + statusId).html(status);

            if(status == "健康"){
                $("#" + jcxzId + ">img").attr("src","static/image/monitorWarning/4.png");
                $("#" + jcxzId + ">i").removeClass("icon-yujing1");
                $("#" + jcxzId + ">i").removeClass("icon-wuranyuan");
                $("#" + jcxzId + ">i").addClass("icon-huanbaoyezishuyemianxing");
                $("#" + statusId).removeClass("bg-top-red");
                $("#" + statusId).removeClass("bg-top-yellow");
                $("#" + statusId).addClass("bg-top-green");
                $("#" + statusId + " .tip").removeClass("red-tip");
                $("#" + statusId + " .tip").removeClass("yellow-tip");
                $("#" + statusId + " .tip").addClass("green-tip");

                //位置调整（原位置隐藏，新位置显示）
                $("#" + statusId + " .tip").css("display","none");
                $("." + statusId).removeClass("red-tip");
                $("." + statusId).removeClass("yellow-tip");
                $("." + statusId).addClass("green-tip");

                $("#" + ghmbnId).removeClass("red-num");
                $("#" + ghmbnId).removeClass("yellow-num");
                $("#" + ghmbnId).addClass("green-num");
            }else if(status == "严重预警"){
                $("#" + jcxzId + ">img").attr("src","static/image/monitorWarning/2.png");
                $("#" + jcxzId + ">i").removeClass("icon-wuranyuan");
                $("#" + jcxzId + ">i").removeClass("icon-huanbaoyezishuyemianxing");
                $("#" + jcxzId + ">i").addClass("icon-yujing1");
                $("#" + statusId).removeClass("bg-top-green");
                $("#" + statusId).removeClass("bg-top-yellow");
                $("#" + statusId).addClass("bg-top-red");
                $("#" + statusId + " .tip").removeClass("green-tip");
                $("#" + statusId + " .tip").removeClass("yellow-tip");
                $("#" + statusId + " .tip").addClass("red-tip");

                //位置调整（原位置隐藏，新位置显示）
                $("#" + statusId + " .tip").css("display","none");
                $("." + statusId).removeClass("green-tip");
                $("." + statusId).removeClass("yellow-tip");
                $("." + statusId).addClass("red-tip");

                $("#" + ghmbnId).removeClass("green-num");
                $("#" + ghmbnId).removeClass("yellow-num");
                $("#" + ghmbnId).addClass("red-num");
            }else{
                $("#" + jcxzId + ">img").attr("src","static/image/monitorWarning/3.png");
                $("#" + jcxzId + ">i").removeClass("icon-yujing1");
                $("#" + jcxzId + ">i").removeClass("icon-huanbaoyezishuyemianxing");
                $("#" + jcxzId + ">i").addClass("icon-wuranyuan");
                $("#" + statusId).removeClass("bg-top-green");
                $("#" + statusId).removeClass("bg-top-red");
                $("#" + statusId).addClass("bg-top-yellow");
                $("#" + statusId + " .tip").removeClass("green-tip");
                $("#" + statusId + " .tip").removeClass("red-tip");
                $("#" + statusId + " .tip").addClass("yellow-tip");

                //位置调整（原位置隐藏，新位置显示）
                $("#" + statusId + " .tip").css("display","none");
                $("." + statusId).removeClass("green-tip");
                $("." + statusId).removeClass("red-tip");
                $("." + statusId).addClass("yellow-tip");

                $("#" + ghmbnId).removeClass("green-num");
                $("#" + ghmbnId).removeClass("red-num");
                $("#" + ghmbnId).addClass("yellow-num");
            }

            //不配图表展示类型就不展示
            if(echartype != null){
                jsonObj.zbTitle = zbTitle;
                jsonObj.unit = unit;
                jsonObj.echartype = echartype;
                jsonAry.push(jsonObj);

                if(maeValues.length > 2 ){

                    if(index == 0 ){
                        liHtml += '<li class="layui-this" lay-id="tabId'+ index +'"></li>';
                        itemHtml += '<div class="layui-tab-item layui-show">';

                    }else{
                        liHtml += '<li lay-id="tabId'+ index +'"></li>';
                        itemHtml += '<div class="layui-tab-item">'
                    }

                    itemHtml += '<div id="echart'+ index +'" class="count-echart"></div></div>';
                }else if(maeValues.length== 1){//maeValues.length==1or2

                    echartHtml = '<div class="content-header"><div><i class="iconfont icon-data_icon9"></i>' +
                        '<span class="content-header-text ml10">'+ zbTitle +'变化情况</span></div></div>' +
                        '<div class="count count-echart"><div id="echart0" class="count-echart"></div></div>';
                }else{
                    echartHtml +='<div class="content-header"><div><i class="iconfont icon-data_icon9"></i>' +
                        '<span class="content-header-text ml10">'+ zbTitle +'变化情况</span></div></div>' +
                        '<div class="count count-echart"><div id="echart-xzq'+ index +'" class="count-echart"></div></div>';
                }

            }
        }
    });

    if(maeValues.length > 2 && jsonAry.length > 0){
        echartHtml = '<div class="content-header"><div><i class="iconfont icon-data_icon9"></i>' +
            '<span class="content-header-text ml10">指标变化情况</span> </div></div>' +
            '<div class="count count-tab"><div class="layui-tab layui-tab-brief" lay-filter="zbTab">' +
            '<ul class="layui-tab-title">'+ liHtml +'</ul>' +
            '<div class="layui-tab-content">'+ itemHtml +'</div></div></div>';
    }

    $("#" + zbxType + "-content-body").append(echartHtml);

    if(jsonAry.length > 1){

        var tabTitle = "";
        jsonAry.forEach(function (value,index) {

            if(jsonAry.length == 2){
                tabTitle = value.zbTitle.substring(value.zbTitle.length - 8);
                $(".layui-tab-title li").removeClass("tab-padding");
                $(".layui-tab-title li").addClass("tab-padding-two");
            }else{
                tabTitle = value.zbTitle.substring(value.zbTitle.length - 6);
                $(".layui-tab-title li").removeClass("tab-padding-two");
                $(".layui-tab-title li").addClass("tab-padding");
            }

            $('li[lay-id="tabId'+index+'"]').html(tabTitle);
            drowEchart(base,params,value,index);
        })
    }else if(jsonAry.length == 1){

        var echartypeAry = jsonAry[0].echartype.split(",");

        echartypeAry.forEach(function (value,index) {
            var jsonObj = {};
            jsonObj.zbTitle = jsonAry[0].zbTitle;
            jsonObj.unit = jsonAry[0].unit;
            jsonObj.echartype = value;
            drowEchart(base,params,jsonObj,index);
        })
    }

    return jsonAry;
}

function drowEchart(base,params,value,index) {

    // params.name = value.zbTitle;
    var param = {id:null,nf:null,xzqdm:null,name:value.zbTitle};
    $.extend(param,params);

    //年折
    if(value.echartype == 1){

        param.nf = null;

        //获取某一地区历史年份的指标值
        var maeValues = getMaeValues(base,param);

        var dataNFXAry=[],dataSAry=[];

        maeValues.forEach(function (value,index) {
            dataNFXAry.push(value.nd);
            dataSAry.push(value.calcuvalue);
        });

        drowLineEchart(index,value,dataNFXAry,dataSAry);
    }else if(value.echartype == 2){//年柱

        param.nf = null;

        //获取某一地区历史年份的指标值
        maeValues = getMaeValues(base,param);

        var dataNFXAry=[],dataSAry=[];

        maeValues.forEach(function (value,index) {
            dataNFXAry.push(value.nd);
            dataSAry.push(value.calcuvalue);
        });
        drowBarEchart(index,value,dataNFXAry,dataSAry);
    }else if(value.echartype == 3){//行折

        //获取当前年份所有地区的指标值
        var maeValues = getMaeValues(base,param);

        var dataXZQXAry=[],dataSAry=[];

        maeValues.forEach(function (value,index) {
            dataXZQXAry.push(value.title);
            dataSAry.push(value.calcuvalue);
        });

        drowLineEchart(index,value,dataXZQXAry,dataSAry);
    }else if(value.echartype == 4){//行柱

        //获取当前年份所有地区的指标值
        maeValues = getMaeValues(base,param);

        var dataXZQXAry=[],dataSAry=[];

        maeValues.forEach(function (value,index) {
            dataXZQXAry.push(value.title)
            dataSAry.push(value.calcuvalue);
        })
        drowBarEchart(index,value,dataXZQXAry,dataSAry);
    }

    //$.extend(param,params);
    //var xzqdmMaeValues = getXzqdmMaeValues(base,param);
    // var XZQDMXAry=[],maeValuesSAry=[];
    //
    // xzqdmMaeValues.forEach(function (value,index) {
    //     XZQDMXAry.push(value.title)
    //     maeValuesSAry.push(value.calcuvalue);
    // })
    //drowXzqdmBarEchart(index,value,XZQDMXAry,maeValuesSAry,param.nf);
}

/**
 * 加载指标折线图
 */
function drowLineEchart(index,value,dataXAry,dataSAry){

    var myEchart = echarts.init(document.getElementById('echart' + index));

    option = {
        tooltip: {
            trigger: 'axis',
            position: ['10%', '20%']
        },
        grid: {
            left: '5%',
            right: '4%',
            top: '20%',
            bottom: '10%',
            containLabel: true
        },
        xAxis: {
            type: 'category',
            data: dataXAry
        },
        yAxis: {
            name: value.unit,
            type: 'value',
            boundaryGap: false,
            splitLine : {
                show : true,
                lineStyle : {
                    width : 1,
                    color : '#ccc'
                }
            }
        },
        series: [{
            name: value.zbTitle,
            symbol: 'circle',
            data: dataSAry,
            type: 'line',
            itemStyle : {
                normal : {
                    color:'#2EC7C9',
                    lineStyle:{
                        color:'#2EC7C9'
                    }
                }
            }
        }]
    };

    myEchart.setOption(option);
    myEchart.resize();
}

/**
 * 加载指标柱状图
 */
function drowBarEchart(index,value,dataXAry,dataSAry) {

    var myEchart = echarts.init(document.getElementById('echart' + index));

    option = {
        tooltip : {
            trigger: 'axis',
            position: ['10%', '20%']
        },
        grid: {
            left: '3%',
            right: '4%',
            top: '20%',
            bottom: '10%',
            containLabel: true
        },
        xAxis : [
            {
                type : 'category',
                data : dataXAry,
                axisLabel: {
                    interval:0,
                    rotate:-40
                }
            }
        ],
        yAxis : [
            {
                type : 'value',
                name : value.unit,
                splitLine : {
                    show : true,
                    lineStyle : {
                        width : 1,
                        color : '#ccc'
                    }
                }
            }
        ],
        series : [
            {
                name: value.zbTitle,
                type:'bar',
                color:'#005FBF',
                barWidth : 20,//柱图宽度
                data: dataSAry
            }
        ]
    };

    myEchart.setOption(option);
    myEchart.resize();
}


/**
 * 加载行政区 柱状图
 */
function drowXqzdmBarEchart(index,value,dataXAry,dataSAry,nf) {

    var myEchart = echarts.init(document.getElementById('echart-xzq' + index));
    option = {
        // legend: {
        //     data: ['2011年']
        // },
        tooltip : {
            trigger: 'axis',
            position: ['10%', '20%']
        },
        grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            top: '1%',
            containLabel: true
        },
        xAxis: {
            type: 'value',
            position: 'top',
            name: '%',
            boundaryGap: [0, 0]
        },
        yAxis: {
            type: 'category',
            data: dataXAry
        },
        series: [
            {
                name: nf+'年',
                type: 'bar',
                color:'#005FBF',
                barWidth : 20,//柱图宽度
                data: dataSAry
            }
        ]
    };
    myEchart.setOption(option);
    myEchart.resize();
}


/**
 * 查询指标值
 */
function getMaeValues(base,params) {
    var maeValues;
    $.ajax({
        url: base + '/ui/monitor/indicator/item-value-list',
        async: false,
        type:"GET",
        dataType:"json",
        data:params,
        success: function(result){
            if (result != null) {
                maeValues = result;
            }
        }
    });
    return maeValues;
}

/**
 * 查询行政区指标值
 */
function getXzqdmMaeValues(base,params) {
    var maeValues;
    $.ajax({
        url: base + '/ui/monitor/indicator/xzqdm-item-value-list',
        async: false,
        type:"GET",
        dataType:"json",
        data:params,
        success: function(result){
            if (result != null) {
                maeValues = result;
            }
        }
    });
    return maeValues;
}
