package cn.gtmap.secondaryMarket.common.web.freemarker;

import cn.gtmap.secondaryMarket.common.constants.CommonConst;
import cn.gtmap.secondaryMarket.common.domain.TransRegion;
import cn.gtmap.secondaryMarket.common.register.TransRegionClient;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 行政区常用方法
 * @author zhujunjie
 */
@Component
public class RegionUtil {

    @Autowired
    private TransRegionClient regionClient;

    public String getRegionName(String regionCode){
        TransRegion region = regionClient.getTransRegionByRegionCode(regionCode);
        return StringUtils.isNotBlank(region.getRegionName()) ? region.getRegionName() : CommonConst.StringValue.EMPTY;
    }

    /**
     * 获取行政区list集合
     * @param regionCode
     * @param regionLevel
     * @param fregionCode
     * @return
     */
    public List<TransRegion> getRegionList(String regionCode, Short regionLevel, String fregionCode){
        return regionClient.findTransRegionList(regionCode, regionLevel, fregionCode);
    }
}
