package cn.gtmap.secondaryMarket.common.web.freemarker;

import cn.gtmap.secondaryMarket.common.constants.CommonConst;
import cn.gtmap.secondaryMarket.common.domain.TransDataDictionary;
import cn.gtmap.secondaryMarket.common.register.TransDataDictionaryClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * 常用字典表方法
 * @author zhujunjie
 */
@Component
public class DataDictionaryUtil {

    @Autowired
    private TransDataDictionaryClient transDataDictionaryClient;

    /**
     * 根据父类编码获取子类集合
     * @param code
     * @return
     */
    public List<TransDataDictionary> getDataListByCode(String code){
        return transDataDictionaryClient.findChildrenListByCode(code);
    }

    /**
     * 获取编码名称
     * @param dataCode
     * @param dataFcode
     * @return
     */
    public String getDataName(String dataCode, String dataFcode){
        String dataName = "";
        TransDataDictionary transDataDictionary = transDataDictionaryClient.getDateByCodeAndFcode(dataCode, dataFcode, null);
        if(transDataDictionary != null){
            dataName = transDataDictionary.getDataName();
        }
        return dataName;
    }

    /**
     * 获取土地用途名称
     * @param tdyt
     * @return
     */
    public String getTdytName(String tdyt){
        return transDataDictionaryClient.getByDateCodes(Arrays.asList(tdyt), CommonConst.DataDictionary.TDYT);
    }
}
