package cn.gtmap.secondaryMarket.common.web.freemarker;

import cn.gtmap.secondaryMarket.common.constants.CommonConst;
import cn.gtmap.secondaryMarket.common.domain.TransDataDictionary;
import cn.gtmap.secondaryMarket.common.register.TransDataDictionaryClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * FreeMarker 常用常量工具类
 *
 * @author zhujunjie
 */
@Component
public class CommonConstUtil {

    /**
     * 管理端系统标题
     */
    private String adminSystemTitle;

    /**
     * 前端系统标题
     */
    private String serverSystemTitle;

    /**
     * 转让类型编码
     */
    private String ZRLX;

    /**
     * 推介类型
     */
    private String TJLX;

    /**
     * 出租类型编码
     */
    private String CZLX;

    /**
     * 抵押类型编码
     */
    private String DYLX;

    /**
     * 发布类型编码
     */
    private String FBLX;

    /**
     * 资讯类型编码
     */
    public String ZXLX;

    /**
     * 置顶类型编码
     */
    public String ZDLX;


    /**
     * 启用类型编码
     */
    public String QYLX;


    /**
     * 失信状态编码
     */
    public String SXZT;

    /**
     * 服务指南类型编码
     */
    public String FWZNLX;

    /**
     * 会员审核状态编码
     */
    public String HYSHZT;
    
    /**
     * 合同状态编码
     */
    public String HTZT;

    /**
     * 出让类型编码
     */
    public String CRLX;

    /**
     * 证件类型
     */
    public String ZJLX;

    /**
     * 土地性质
     */
    public String TDXZ;

    /**
     * 权属号码
     */
    public String QSHM;

    /**
     * 权属来源
     */
    public String QSLY;

    /**
     * 转让方式
     */
    public String ZRFS;

    /**
     * 转让范围
     */
    public String ZRFW;

    /**
     * 抵押证件范围
     */
    public String DYZJLX;

    /**
     * 代理人类型
     */
    public String DLRLX;

    /**
     * 是否发布
     */
    public String SFFB;

    /**
     * 图片位置
     */
    public String TPWZ;

    /**
     * 图片大小
     */
    public String TPDX;

    /**
     * 机构类型
     */
    public String JGLX;
    
    /**
     * 交易物类型
     */
    public String LANDTYPE;

    /**
     * 建筑结构
     */
    public String JZJG;
    
    /**
     * 权属人性质
     */
    public String QSRXZ;

    /**
     * 审核类型
     */
    public String ZGSH;
    /**
     * 土地类型
     */
    private String TDYT;

    @Autowired
    private TransDataDictionaryClient transDataDictionaryClient;

    public String getAdminSystemTitle() {
        TransDataDictionary dataDictionary = transDataDictionaryClient.getDateByCodeAndFcode(CommonConst.DataCode.HTBT,CommonConst.DataCode.TITLE,null);
        return dataDictionary == null ? "" : dataDictionary.getDataName();
    }

    public String getServerSystemTitle() {
        TransDataDictionary dataDictionary = transDataDictionaryClient.getDateByCodeAndFcode(CommonConst.DataCode.QTBT,CommonConst.DataCode.TITLE,null);
        return dataDictionary == null ? "" : dataDictionary.getDataName();
    }

    public String getZRLX() {
        return CommonConst.DataCode.ZRLX;
    }

    public String getTJLX() {
        return CommonConst.DataCode.TJLX;
    }

    public String getCZLX() {
        return CommonConst.DataCode.CZLX;
    }

    public String getDYLX() {
        return CommonConst.DataCode.DYLX;
    }

    public String getFBLX() {
        return CommonConst.DataCode.FBLX;
    }

    public String getZXLX() {
        return CommonConst.DataCode.ZXLX;
    }

    public String getZDLX() {
        return CommonConst.DataCode.ZDLX;
    }

    public String getQYLX() {
        return CommonConst.DataCode.QYLX;
    }

    public String getSXZT() {
        return CommonConst.DataCode.SXZT;
    }

    public String getFWZNLX() {
        return CommonConst.DataCode.FWZNLX;
    }

    public String getHYSHZT() {
        return CommonConst.DataCode.HYSHZT;
    }
    
    public String getHTZT() {
    	return CommonConst.DataCode.HTZT;
    }

    public String getCRLX() {
        return CommonConst.DataCode.CRLX;
    }

    public String getZJLX() {
        return CommonConst.DataCode.ZJLX;
    }

    public String getTDXZ() {
        return CommonConst.DataCode.TDXZ;
    }

    public String getQSHM() {
        return CommonConst.DataCode.QSHM;
    }

    public String getQSLY() {
        return CommonConst.DataCode.QSLY;
    }

    public String getZRFS() {
        return CommonConst.DataCode.ZRFS;
    }

    public String getZRFW() {
        return CommonConst.DataCode.ZRFW;
    }

    public String getDYZJLX() {
        return CommonConst.DataCode.DYZJLX;
    }

    public String getDLRLX() {
        return CommonConst.DataCode.DLRLX;
    }

    public String getSFFB() {
        return CommonConst.DataCode.SFFB;
    }

    public String getTPWZ() {
        return CommonConst.DataCode.TPWZ;
    }

    public String getTPDX() {
        return CommonConst.DataCode.TPDX;
    }

    public String getJGLX() {
        return CommonConst.DataCode.JGLX;
    }
    
    public String getLANDTYPE() {
        return CommonConst.DataCode.LANDTYPE;
    }
    
    public String getJZJG() {
        return CommonConst.DataCode.JZJG;
    }
    
    public String getQSRXZ() {
        return CommonConst.DataCode.QSRXZ;
    }

    public String getZGSH() {
        return CommonConst.DataCode.ZGSH;
    }

	public String getTDYT() {
		return CommonConst.DataCode.TDYT;
	}

}
