/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: NodeHelper.java
 *
 * LastModified: 2009-09-23 04:00:12
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package cn.gtmap.secondaryMarket.common.utils.fileCenter;

import cn.gtmap.secondaryMarket.common.domain.fileCenter.File;
import cn.gtmap.secondaryMarket.common.domain.fileCenter.Node;
import cn.gtmap.secondaryMarket.common.domain.fileCenter.Space;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-15
 */
public class NodeHelper {

	public static final String PREFIX = "fc_";

	public static Map<String, Object> nodeToJson(Node node) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("id", node.getId());
		map.put("parentId", node.getParentId());
		map.put("name", node.getName());
		map.put("viewName", node.getViewName());
		map.put("icon", node.getIcon());
		map.put("type", node.getType());
		map.put("scope", node.getScope());
		map.put("description", node.getDescription());
		map.put("owner", node.getOwner());
		map.put("updateTime", node.getUpdateTime());
		if (node.getAttributes() != null) {
			map.put("attrs", node.getAttributes());
		}
		if (node instanceof Space) {
			Space space = ((Space) node);
			map.put("size", space.getSize());
			map.put("usedSize", space.getUsedSize());
		} else if (node instanceof File) {
			File file = (File) node;
			map.put("size", file.getSize());
			if (file.isImage())
				map.put("isImage", Boolean.TRUE);
			else if (file.isDocument())
				map.put("isDoc", Boolean.TRUE);
		} else {
			if (node.getChildCount() != null)
				map.put("childCount", node.getChildCount());
		}
		return map;
	}

	public static List<Map<String, Object>> nodesToJson(List<Node> nodes) {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>(nodes.size());
		for (Node node : nodes)
			list.add(nodeToJson(node));
		return list;
	}

	public static Integer getIntegerParameter(HttpServletRequest request, String name) {
		String i = request.getParameter(name);
		if (StringUtils.isNotBlank(i))
			try {
				return Integer.valueOf(i);
			} catch (NumberFormatException ignored) {
			}
		return null;
	}

	public static String toIndexId(Integer id) {
		return PREFIX + id;
	}

	public static Integer toFileId(String id) {
		return Integer.valueOf(id.substring(3));
	}
}
