package cn.gtmap.secondaryMarket.common.utils.db;

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.List;

/**
 * 配合Feign 分页返回
 * @author zsj
 * @version v1.0, 2018/5/8
 */
public class PageResponse<E> implements Serializable {

    private static final long serialVersionUID = 1L;

    private int pageNum;     //当前页，从1开始
    private int pageSize;   //每页记录数量
    private int startRow;    //起始记录，从0开始
    private int endRow;
    private long total;    //总记录数
    private int pages;   //总页数
    private List<E> resultList = Lists.newArrayList();

    public PageResponse() {
    }

    public PageResponse(int pageNum, int pageSize, int startRow, int endRow, long total, int pages, List<E> resultList) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.startRow = startRow;
        this.endRow = endRow;
        this.total = total;
        this.pages = pages;
        this.resultList = resultList;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getStartRow() {
        return startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getEndRow() {
        return endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPages() {
        return pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public List<E> getResultList() {
        return resultList;
    }

    public void setResultList(List<E> resultList) {
        this.resultList = resultList;
    }

    @Override
    public String toString() {
        return "PageResponse{" +
                "pageNum=" + pageNum +
                ", pageSize=" + pageSize +
                ", startRow=" + startRow +
                ", endRow=" + endRow +
                ", total=" + total +
                ", pages=" + pages +
                '}';
    }

    public static class ConvertPage {
        public static PageResponse convertPage(Page page) {
            return new PageResponse(page.getPageNum(), page.getPageSize(), page.getStartRow(), page.getEndRow(), page.getTotal(), page.getPages(), page.getResult());
        }

    }

    public static class FrameWorkConvertPage {
        public static PageResponse convertPage(org.springframework.data.domain.Page page) {
            return new PageResponse(page.getNumber()+ 1, page.getSize(), page.getNumber()*page.getSize(), (page.getNumber() + 1)*page.getSize(), page.getTotalElements(), page.getTotalPages(), page.getContent());
        }

    }

    public static class EgovplatConvertPage {
        public static PageResponse convertPage(cn.gtmap.egovplat.core.data.Page page) {
            return new PageResponse(page.getOffset()+1, page.getSize(), (page.getIndex() -1) * page.getSize(), page.getIndex()* page.getSize(), page.getTotalCount(), page.getPageCount(), page.getItems());
        }

    }
}
