package cn.gtmap.secondaryMarket.common.utils.db;

import java.io.Serializable;

/**
 * Created by JIFF on 2016/11/23.
 */
public class PageRequest implements Serializable {


    private int pageNum;     //当前页，从1开始
    private int pageSize;   //每页记录数量
    private int startRow;    //起始记录，从0开始
    private int endRow;
    private long total;    //总记录数
    private int pages;   //总页数

    public PageRequest(){

    }

    public PageRequest(int pageNum, int pageSize) {
        this(pageNum, pageSize, 1);
    }

    public PageRequest(int startRow, int endRow, int pageNum, int pageSize) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = 1;
    }

    public PageRequest(int pageNum, int pageSize, int total) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
        this.startRow = pageNum > 0 ? (pageNum - 1) * pageSize : 0;
        this.endRow = pageNum * pageSize;
    }

    public Page getPage(){
        return  new Page(pageNum, pageSize, total);
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getStartRow() {
        return startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getEndRow() {
        return endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getPages() {
        return pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }
}
