/*
 * Project:  hydroplat-parent
 * Module:   hydroplat-common
 * File:     PageDefault.java
 * Modifier: yangxin
 * Modified: 2014-06-13 22:22
 *
 * Copyright (c) 2014 Mapjs All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent
 * or the registration of a utility model, design or code.
 */

package cn.gtmap.secondaryMarket.common.utils.db;

import java.lang.annotation.*;

@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PARAMETER)
public @interface PageDefault {
    int SIZE_DEFAULT = 20;
    int INDEX_FIRST = 1;
    int COUNT=0;
    /**
     * 页大小
     */
    int value() default SIZE_DEFAULT;

    /**
     * 页号
     */
    int index() default INDEX_FIRST;

    int offset() default 0;

    /**
     * 记录数
     * @return
     */
    int count() default COUNT;

    /**
     * 排序,语法同sql,如:
     * name asc,age desc
     * id
     */
    String sort() default "";
    /**
     * 参数前缀,如user,则传递参数为user_size,user_index,user_offset;
     */
    String prefix() default "";
}
