package cn.gtmap.secondaryMarket.common.utils.db;

import org.apache.ibatis.session.RowBounds;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by JIFF on 2016/11/23.
 */
public class Page<E> extends ArrayList<E> implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final int NO_SQL_COUNT = 1;      //控制是否进行count查询
    public static final int SQL_COUNT = 0;
    private int pageNum;     //当前页，从1开始
    private int pageSize;   //每页记录数量
    private int startRow;    //起始记录，从0开始
    private int endRow;
    private long total;    //总记录数
    private int pages;   //总页数
    public static int defaultPageSize=20;   //缺省每页大小

    public Page(int pageNum, int pageSize, int startRow, int endRow, int total, int pages){
        super(pageSize);
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.pageNum = startRow;
        this.pageSize = endRow;
        this.total = total;
        this.total = pages;
    }

    public Page(){

    }

    public Page(int pageNum, int pageSize) {
        this(pageNum, pageSize, NO_SQL_COUNT);
    }

    public Page(int pageNum, int pageSize, long total) {
        //if(pageSize<1) pageSize=defaultPageSize;
        //if(pageNum<1) pageNum=1;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
        this.startRow = pageNum > 0 ? (pageNum - 1) * pageSize : 0;
        this.endRow = pageNum * pageSize;
    }

    public Page(RowBounds rowBounds, int total) {
        super(rowBounds.getLimit());
        this.pageSize = rowBounds.getLimit();
        this.startRow = rowBounds.getOffset();
        this.total = total;
        this.endRow = this.startRow + this.pageSize;
    }



    public List<E> getResult() {
        return this;
    }

    public int getPages() {
        if (pageSize > 0 && total > 0) {
            pages = new BigDecimal(total).divide(new BigDecimal(pageSize), 2).setScale(0, BigDecimal.ROUND_UP).intValue();
        }
        return pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public int getEndRow() {
        return endRow;
    }

    public void setEndRow(int endRow) {
        this.endRow = endRow;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getStartRow() {
        return startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    @Override
    public String toString() {
        return "Page{" +
                "pageNum=" + pageNum +
                ", pageSize=" + pageSize +
                ", startRow=" + startRow +
                ", endRow=" + endRow +
                ", total=" + total +
                ", pages=" + pages +
                '}';
    }

}
