package cn.gtmap.secondaryMarket.common.utils.db;

import cn.gtmap.egovplat.core.data.P;
import cn.gtmap.egovplat.core.data.Pageable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

/**
 * 注解HibernatePageDefault处理
 * @author zhujunjie
 * @version v1.0, 2018/5/12
 */
@Configuration
public class HibernateDataPageableHandlerMethodArgumentResolver implements HandlerMethodArgumentResolver {

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return Pageable.class.equals(parameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        HibernatePageDefault def = parameter.getParameterAnnotation(HibernatePageDefault.class);
        Integer size;
        Integer offset;
        Integer index;
        if (def != null) {
            size = this.getParam(webRequest, "size", def.prefix(), def.value());
            offset = this.getParam(webRequest, "offset", def.prefix(), def.offset());
            index = this.getParam(webRequest, "index", def.prefix(), def.index());
        } else {
            size = this.getParam(webRequest, "size", (String)null, (Integer)null);
            offset = this.getParam(webRequest, "offset", (String)null, (Integer)null);
            index = this.getParam(webRequest, "index", (String)null, (Integer)null);
        }

        if (size == null && offset == null && index == null) {
            return P.DEFAULT;
        } else {
            if (size == null) {
                size = 20;
            }

            if (index != null) {
                return P.index(index == 0 ? 1 : index, size);
            } else {
                if (offset == null) {
                    offset = 0;
                }

                return P.offset(offset, size);
            }
        }
    }

    private Integer getParam(NativeWebRequest webRequest, String name, String prefix, Integer def) {
        String s = webRequest.getParameter(StringUtils.isEmpty(prefix) ? name : prefix + "_" + name);
        return StringUtils.isNoneEmpty(new CharSequence[]{s}) ? Integer.valueOf(s) : def;
    }
}
