package cn.gtmap.secondaryMarket.common.utils.db;

import cn.gtmap.secondaryMarket.common.constants.CommonConst;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

/**
 * 注解PageDefault处理
 * @author zsj
 * @version v1.0, 2018/5/12
 */
@Configuration
public class    DataPageableHandlerMethodArgumentResolver implements HandlerMethodArgumentResolver {


    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return PageRequest.class.equals(parameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Integer size;
        Integer index;
        Integer count=0;
        PageDefault def = parameter.getParameterAnnotation(PageDefault.class);
        if (def != null) {
            if (StringUtils.isNotEmpty(webRequest.getParameter("index"))) {
                index = getParam(webRequest, "index", def.prefix(), Integer.parseInt(webRequest.getParameter("index")));
            } else {
                index = getParam(webRequest, "index", def.prefix(), def.value());
            }
            size = getParam(webRequest, "size", def.prefix(), def.value());
            count= 1;
        } else {
            if (StringUtils.isNotEmpty(webRequest.getParameter("index"))) {
                index = getParam(webRequest, "index", null, Integer.parseInt(webRequest.getParameter("index")));
            } else {
                index = getParam(webRequest, "index", null, CommonConst.NumberValue.NUM_1);
            }
            if (StringUtils.isNotEmpty(webRequest.getParameter("size"))) {
                size = getParam(webRequest, "size", null, Integer.parseInt(webRequest.getParameter("size")));
            } else {
                size = getParam(webRequest, "size", null,  CommonConst.NumberValue.NUM_10);
            }
            if (StringUtils.isNotEmpty(webRequest.getParameter("count"))) {
                count = getParam(webRequest, "count", null, Integer.parseInt(webRequest.getParameter("count")));
            } else {
                count = getParam(webRequest, "count", null,  CommonConst.NumberValue.NUM_1);
            }
        }
        if (size == null || size==0) {
            size= PageDefault.SIZE_DEFAULT;
        }
        if (index == null || index<1) {
            index= PageDefault.SIZE_DEFAULT;
        }
        if (count == null) {
            count=1;
        }
       return new PageRequest(index,size,count);
    }

    private Integer getParam(NativeWebRequest webRequest, String name, String prefix, Integer def) {
        String s = webRequest.getParameter(StringUtils.isEmpty(prefix) ? name : prefix + "_" + name);
        return StringUtils.isNotEmpty(s) ? Integer.valueOf(s) : def;
    }
}
