package cn.gtmap.secondaryMarket.common.utils;

import com.alibaba.fastjson.JSONObject;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;


public class Xml2JsonUtil {


    /**
     * 转换一个xml格式的字符串到json格式
     *
     * @param xml
     *            xml格式的字符串
     * @return 成功返回json 格式的字符串;失败反回null
     */
    @SuppressWarnings("unchecked")
    public static JSONObject xml2JSON(String xml) {
        JSONObject obj = new JSONObject();
        try {
            Document doc = DocumentHelper.parseText(xml);
            Element root = doc.getRootElement();
            obj.put(root.getName(), iterateElement(root));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    /**
     * 一个迭代方法
     *
     * @param element
     * @return java.util.Map 实例
     */
    @SuppressWarnings("unchecked")
    private static Map  iterateElement(Element element) {
        List jiedian = element.elements();
        Element et = null;
        Map obj = new HashMap();
        Object temp;
        List list = null;
        for (int i = 0; i < jiedian.size(); i++) {
            list = new LinkedList();
            et = (Element) jiedian.get(i);
            if ("".equals(et.getTextTrim())) {
                if (et.elements().size() == 0) {
                    continue;
                }
                if (obj.containsKey(et.getName())) {
                    temp = obj.get(et.getName());
                    if(temp instanceof List){
                        list = (List)temp;
                        list.add(iterateElement(et));
                    }else if(temp instanceof Map){
                        list.add((HashMap)temp);
                        list.add(iterateElement(et));
                    }else{
                        list.add((String)temp);
                        list.add(iterateElement(et));
                    }
                    obj.put(et.getName(), list);
                }else{
                    obj.put(et.getName(), iterateElement(et));
                }
            } else {
                if (obj.containsKey(et.getName())) {
                    temp = obj.get(et.getName());
                    if(temp instanceof List){
                        list = (List)temp;
                        list.add(et.getTextTrim());
                    }else if(temp instanceof Map){
                        list.add((HashMap)temp);
                        list.add(iterateElement(et));
                    }else{
                        list.add((String)temp);
                        list.add(et.getTextTrim());
                    }
                    obj.put(et.getName(), list);
                }else{
                    obj.put(et.getName(), et.getTextTrim());
                }

            }

        }
        return obj;
    }

    // 测试
    public static void main(String[] args) {
        String xmlStr = "<getOmElement>" +
                "<HEADER>" +
                "<SOURCEID>MDM</SOURCEID>" +
                "<SOURCEID>MDM</SOURCEID>" +
                "<myChild/>"+
                "<DESTINATIONID>DAXT</DESTINATIONID>" +
                "<SIZE>1</SIZE>" +
                "<TYPE>ADD</TYPE>" +
                "<BO>ORG</BO>" +
                "<CHECK>"+
                "checkCode"
                +"</CHECK>"+
                "</HEADER>" +
                "<REQUEST>" +
                "<DATAROW>" +
                "<ORGUUID>460c5239-13f662e8f67-2f1936027f000a1d675dd1399911234</ORGUUID>" +
                "</DATAROW>" +
                "<DATAROW>" +
                "<ORGUUID>460c5239-13f662e8f67-2f1936027f000a1d675dd139991369c4</ORGUUID>" +
                "</DATAROW>" +
                "</REQUEST>" +
                "</getOmElement>";

        System.out.println(Xml2JsonUtil.xml2JSON(xmlStr));
    }
}