package cn.gtmap.secondaryMarket.common.utils;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;

import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @作者 王建明
 * @创建日期 2012-5-24
 * @创建时间 上午09:11:25
 * @版本号 V 1.0
 */
public class UrlPostUtil {
	static Logger logger = LoggerFactory.getLogger(UrlPostUtil.class);
	
	/**
	 * 描述：获取url参数
	 * @author 卜祥东
	 * 2022年1月12日 下午5:12:41
	 * @param url
	 * @param name
	 * @return
	 */
	public static String getParam(String url, String name) {
	    String params = url.substring(url.indexOf("?") + 1, url.length());
	    Map<String, String> split = Splitter.on("&").withKeyValueSeparator("=").split(params);
	    return split.get(name);
	}

	/**
	 * @param htmlurl
	 * @return
	 * @throws IOException
	 * @作者 王建明
	 * @创建日期 2012-5-24
	 * @创建时间 上午11:30:50
	 * @描述 —— 读取一个网页全部内容
	 */
	public static String getOneHtml(final String htmlurl) throws IOException {
		URL url;
		String temp;
		final StringBuffer sb = new StringBuffer();
		try {
			url = new URL(htmlurl);
			final BufferedReader in = new BufferedReader(new InputStreamReader(
					url.openStream(), "utf-8"));// 读取网页全部内容
			while ((temp = in.readLine()) != null) {
				sb.append(temp);
			}
			in.close();
		} catch (final MalformedURLException me) {
			System.out.println("你输入的URL格式有问题！请仔细输入");
			me.getMessage();
			throw me;
		} catch (final IOException e) {
			logger.error("", e);
			throw e;
		}
		return sb.toString();
	}

	/**
	 * @param urlStr
	 * @param filePath
	 * @throws IOException
	 * @作者 王建明
	 * @创建日期 2012-5-24
	 * @创建时间 下午01:48:20
	 * @描述 —— url地址下载文件并保存
	 */
	public static File downLoadFile(String urlStr, String filePath)
			throws Exception {
		URL url = new URL(urlStr);
		File file = new File(filePath);
		File parent = file.getParentFile();
		if (!parent.exists())
			parent.mkdirs();
		if (file.exists()) {
			file.delete();
		}
		file.createNewFile();
		OutputStream os = new FileOutputStream(file);
		InputStream is = url.openStream();
		byte[] buff = new byte[1024];
		while (true) {
			int readed = is.read(buff);
			if (readed == -1) {
				break;
			}
			byte[] temp = new byte[readed];
			System.arraycopy(buff, 0, temp, 0, readed);
			os.write(temp);
		}
		is.close();
		os.close();
		// **************************************
		return file;
	}

	/**
	 * @param url
	 * @param params
	 * @return
	 * @作者 王建明
	 * @创建日期 2012-7-19
	 * @创建时间 下午04:27:05
	 * @描述 —— 动态发送url请求获取返回字符串数据
	 */
	public static String postUrlDataForString(String url, Map<String, String> params) {
		UTF8PostMethod utf8 = new UTF8PostMethod(url);
		PostMethod postMethod = utf8;
		postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
		postMethod.setRequestHeader("Accept", "application/json;charset=UTF-8");
		if (params != null) {
			Set<String> keys = params.keySet();
			NameValuePair[] postData = new NameValuePair[keys.size()];
			int i = 0;
			Iterator<String> iterator = keys.iterator();
			while (iterator.hasNext()) {
				String key = iterator.next();
				postData[i++] = new NameValuePair(key, params.get(key));
			}

			postMethod.addParameters(postData);
		}

		HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
		connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
		connectionManager.getParams().setConnectionTimeout(30000);
		connectionManager.getParams().setSoTimeout(30000);
		HttpClient httpClient = new HttpClient(connectionManager);
		try {
			httpClient.executeMethod(postMethod);
			return postMethod.getResponseBodyAsString();
		} catch (HttpException e) {
			// TODO Auto-generated catch block
			logger.error("", e);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			logger.error("", e);
		}
		return null;
	}

	/**
	 * @param url
	 * @param params
	 * @return
	 * @作者 王建明
	 * @创建日期 2012-7-19
	 * @创建时间 下午04:27:05
	 * @描述 —— 动态发送url请求获取返回流数据
	 */
	public static InputStream postUrlDataForStream(String url, Map<String, String> params) {
		UTF8PostMethod utf8 = new UTF8PostMethod(url);
		PostMethod postMethod = utf8;
		Set<String> keys = params.keySet();
		NameValuePair[] postData = new NameValuePair[keys.size()];
		int i = 0;
		Iterator<String> iterator = keys.iterator();
		while (iterator.hasNext()) {
			String key = iterator.next();
			postData[i++] = new NameValuePair(key, params.get(key));
		}

		postMethod.addParameters(postData);

		HttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
		connectionManager.getParams().setDefaultMaxConnectionsPerHost(10);
		connectionManager.getParams().setConnectionTimeout(30000);
		connectionManager.getParams().setSoTimeout(30000);
		HttpClient httpClient = new HttpClient(connectionManager);
		try {
			httpClient.executeMethod(postMethod);
			return postMethod.getResponseBodyAsStream();
		} catch (HttpException e) {
			// TODO Auto-generated catch block
			logger.error("", e);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			logger.error("", e);
		}
		return null;
	}

	public String sendByPost(String url, Map<String, String> params, File upload) {
		try {
			InputStream inputStream = new FileInputStream(upload);
			CloseableHttpClient httpClient = HttpClients.createDefault();
			// 创建 POST请求
			HttpPost httpPost = new HttpPost(url);
			// 构建多组件 Entrity构建器
			MultipartEntityBuilder builder = MultipartEntityBuilder.create();
			builder.setCharset(Charsets.UTF_8);
			builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
			//文件传输http请求头(multipart/form-data)
			builder.addBinaryBody("file", inputStream, ContentType.MULTIPART_FORM_DATA, upload.getName());// 文件流
			//字节传输http请求头(application/json)
			ContentType contentType = ContentType.create("application/json", Charsets.UTF_8);
			if (params != null) {
				for (String key : params.keySet()) {
					builder.addTextBody(key, params.get(key), contentType);
				}
			}
			HttpEntity entity = builder.build();
			httpPost.setEntity(entity);
			HttpResponse response = httpClient.execute(httpPost);
			// 执行提交
			HttpEntity responseEntity = response.getEntity();
			if (responseEntity != null) {
				// 将响应内容转换为字符串
				return EntityUtils.toString(responseEntity, Charsets.UTF_8);
			}
		} catch (Exception e) {
			logger.error("", e);
		}
		return "";
	}

	public static String filterNullStr(Object obj) {
		if (obj == null) {
			return "";
		}
		return String.valueOf(obj);
	}

	public static String requestServiceJson(String toURL, String data)
			throws Exception {
		logger.info("外部接口请求url:"+toURL);
		logger.info("外部接口请求参数:"+data);
		StringBuffer bs = new StringBuffer();
		URL sendUrl = new URL(toURL.trim());
		URLConnection connection = sendUrl.openConnection();
		connection.setConnectTimeout(30000);
		connection.setReadTimeout(30000);
		connection.setDoOutput(true);
		connection.setRequestProperty("Content-Type", "application/json;chert=UTF-8");
		OutputStreamWriter out = new OutputStreamWriter(
				connection.getOutputStream(), "UTF-8");
		out.write(data);
		out.flush();
		out.close();
		connection.connect();
		InputStream is = connection.getInputStream();
		BufferedReader buffer = new BufferedReader(new InputStreamReader(is, "UTF-8"));

		String l = null;
		while ((l = buffer.readLine()) != null) {
			bs.append(l);
		}
		logger.info("外部接口请求返回:"+bs.toString());
		return bs.toString();
	}

	public static String getFileName(String url) {
		String filename = "";
		boolean isok = false;
		// 从UrlConnection中获取文件名称
		try {
			URL myURL = new URL(url);
			URLConnection conn = myURL.openConnection();
			if (conn == null) {
				return null;
			}
			Map<String, List<String>> hf = conn.getHeaderFields();
			if (hf == null) {
				return null;
			}
			Set<String> key = hf.keySet();
			if (key == null) {
				return null;
			}
			// Log.i("test", "getContentType:" + conn.getContentType() + ",Url:"
			// + conn.getURL().toString());
			for (String skey : key) {
				List<String> values = hf.get(skey);
				for (String value : values) {
					String result;
					try {
						result = new String(value.getBytes("ISO-8859-1"), "GBK");
						int location = result.indexOf("filename");
						if (location >= 0) {
							result = result.substring(location
									+ "filename".length());
							filename = result.substring(result.indexOf("=") + 1);
							filename = URLDecoder.decode(filename, "UTF-8");
							filename = filename.substring(1, filename.length() - 1);
							isok = true;
						}
					} catch (UnsupportedEncodingException e) {
						e.printStackTrace();
					}// ISO-8859-1 UTF-8 gb2312
				}
				if (isok) {
					break;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		// 从路径中获取
		if (StringUtils.isBlank(filename)) {
			filename = url.substring(url.lastIndexOf("/") + 1);
		}
		return filename;
	}
}
