package cn.gtmap.secondaryMarket.common.utils.UploadUtil;

import cn.gtmap.secondaryMarket.common.constants.CommonConst;
import cn.gtmap.secondaryMarket.common.domain.TFj;
import cn.gtmap.secondaryMarket.common.utils.DateUtils.DateUtil;
import cn.gtmap.secondaryMarket.common.utils.UuidUtil;
import com.google.common.collect.Maps;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.*;

/**
 * Created by Administrator on 2016/12/22.
 */
public class UploadUtil {

    /**
     * 文件保存通用方法
     * @param files 文件
     * @param location 保存的地址
     * @param fjLx 附件类型
     * @return
     */
    public static List<TFj> upload(MultipartFile[] files, Path location, short fjLx){
        Map map= Maps.newHashMap();
        List<TFj> fjList = new ArrayList<>();
        if(files!=null&&files.length>0){
            String[] saveName=new String[files.length];//存放包含文件名的文件地址
            //循环获取file数组中得文件
            for(int i = 0;i<files.length;i++){
                TFj tfj=new TFj();
                MultipartFile file = files[i];
                if(file != null){
                    //取得当前上传文件的文件名称
                    String myFileName = file.getOriginalFilename();
                    //如果名称不为“”,说明该文件存在，否则说明该文件不存在
                    if(myFileName.trim() !=""){
                        String uuid= UuidUtil.createUuid();
                        //重命名上传后的文件名防止同名文件覆盖
                        String fileName = uuid+"_" + file.getOriginalFilename();
                        //定义上传路径
                        if (Files.exists(location)) {
                            location = location.resolve(fileName);
                        } else {
                            try {
                                Files.createDirectories(location);
                                location = location.resolve(fileName);
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            Files.copy(file.getInputStream(), location);
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                        //返回编码之后的文件名称
                        try {
                            fileName = URLEncoder.encode(fileName, "UTF-8");
                        } catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        String fjLj=location.toAbsolutePath().toString();
                        tfj.setFjFilename(fileName);
                        tfj.setFjMc(myFileName);
                        tfj.setCreateDate(DateUtil.getNow());
                        tfj.setFjGuid(uuid);
                        tfj.setFjLx(fjLx);
                        tfj.setFjLj(fjLj);
                    }
                }
                fjList.add(tfj);
            }

        }
        return fjList;
    }

}
