package cn.gtmap.secondaryMarket.common.utils;

import cn.gtmap.secondaryMarket.common.domain.LayuiTree;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 递归拼接layui导航树结构
 * @author zhujunjie
 */
public class TreeBuilder {

    List<LayuiTree> nodes = new ArrayList<>();

    public List<LayuiTree> buildTree(List<LayuiTree> nodes) {

        TreeBuilder treeBuilder = new TreeBuilder(nodes);

        return treeBuilder.buildJSONTree();
    }

    public TreeBuilder() {
    }

    public TreeBuilder(List<LayuiTree> nodes) {
        super();
        this.nodes = nodes;
    }

    // 构建JSON树形结构
    public List<LayuiTree> buildJSONTree() {
        List<LayuiTree> nodeTree = buildTree();
        return nodeTree;
    }

    // 构建树形结构
    public List<LayuiTree> buildTree() {
        List<LayuiTree> treeLayuiTrees = new ArrayList<>();
        List<LayuiTree> rootLayuiTrees = getRootLayuiTrees();
        for (LayuiTree rootLayuiTree : rootLayuiTrees) {
            buildChildLayuiTrees(rootLayuiTree);
            treeLayuiTrees.add(rootLayuiTree);
        }
        return treeLayuiTrees;
    }

    // 递归子节点
    public void buildChildLayuiTrees(LayuiTree node) {
        List<LayuiTree> children = getChildLayuiTrees(node);
        if (!children.isEmpty()) {
            for (LayuiTree child : children) {
                buildChildLayuiTrees(child);
            }
            node.setChildren(children);
        }
    }

    // 获取父节点下所有的子节点
    public List<LayuiTree> getChildLayuiTrees(LayuiTree pnode) {
        List<LayuiTree> childLayuiTrees = new ArrayList<>();
        for (LayuiTree n : nodes) {
            if (pnode.getId().equals(n.getpId())) {
                childLayuiTrees.add(n);
            }
        }
        return childLayuiTrees;
    }

    // 判断是否为根节点
    public boolean rootLayuiTree(LayuiTree node) {
        boolean isRootLayuiTree = true;
        for (LayuiTree n : nodes) {
            if(StringUtils.equals(node.getpId(),n.getId())){
                isRootLayuiTree = false;
                break;
            }
        }
        return isRootLayuiTree;
    }

    // 获取集合中所有的根节点
    public List<LayuiTree> getRootLayuiTrees() {
        List<LayuiTree> rootLayuiTrees = new ArrayList<>();
        for (LayuiTree n : nodes) {
            if (rootLayuiTree(n)) {
                rootLayuiTrees.add(n);
            }
        }
        return rootLayuiTrees;
    }
}
