package cn.gtmap.secondaryMarket.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;

import org.apache.axis.types.URI;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.request.AlibabaAliqinFcSmsNumSendRequest;
import com.taobao.api.response.AlibabaAliqinFcSmsNumSendResponse;

import cn.gtmap.secondaryMarket.common.domain.model.SmsModel;
import cn.gtmap.sms.cmcc.xy.schema.sms.MessageFormat;
import cn.gtmap.sms.cmcc.xy.schema.sms.SendMethodType;
import cn.gtmap.sms.cmcc.xy.schema.sms.SendSmsRequest;
import cn.gtmap.sms.cmcc.xy.service.Cmcc_mas_wbsProxy;

/**
 * @作者 王建明
 * @创建日期 2020/10/20 20:47
 * @描述
 */
public class SmsUtil {
	private static final char hexDigits[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e',
	'f' };
	protected static final Logger logger = LoggerFactory.getLogger(SmsUtil.class);

	private static final String URL = "http://gw.api.taobao.com/router/rest";
	private static final String APPKEY = "23723682";
	private static final String SECRET = "b7da3ecaf042da1448e26f4467262c23";

	private static final String TEMPLATE_CODE = "SMS_184830698";
	
	private static String apId = "gtcadm";
	private static String secretKey = "Gtis@2022";
	private static String ecName = "政务通（连云港市国土资源局）1";    //集团名称
	private static String sign = "Alk2ohDFx";    //网关签名编码
	private static String addSerial = "";    //拓展码 填空
	public static String normalUrl = "http://112.35.10.201:5992/sms/norsubmit";//请求url
	public static String templateUrl = "http://112.35.1.155:1992/sms/tmpsubmit";//请求url

	/**
	 * @作者 王建明
	 * @创建日期 2020-10-28 13:48
	 * @描述 连云港自定义短信内容发送
	 */
	public static String sendSmsContentLyg(String mobile, String content, String smsUrl, String appID) {
		try {
			Cmcc_mas_wbsProxy obj = new Cmcc_mas_wbsProxy(smsUrl);

			SendSmsRequest request = new SendSmsRequest();
			request.setApplicationID(appID);
			request.setDeliveryResultRequest(true);
			request.setExtendCode("");

			request.setMessage(content);
			request.setMessageFormat(MessageFormat.GB2312);
			request.setSendMethod(SendMethodType.Long);

			String[] phoneAry = new String[]{"tel:" + mobile};
			URI[] ary = new URI[phoneAry.length];
			for (int i = 0; i < phoneAry.length; i++) {
				URI temp = new URI(phoneAry[i]);
				ary[i] = temp;
			}
			request.setDestinationAddresses(ary);

			//发送短信
			obj.sendSms(request);
			
			return "";
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return "短信发送异常！" + e.getLocalizedMessage();
		}
	}

	public static String sendSms(String mobile, String code) {
		if (StringUtils.isNotBlank(mobile)) {

			try {
				TaobaoClient client = new DefaultTaobaoClient(URL, APPKEY, SECRET);
				AlibabaAliqinFcSmsNumSendRequest req = new AlibabaAliqinFcSmsNumSendRequest();
				req.setSmsType("normal");
				req.setSmsFreeSignName("\u6765\u8BBF\u767B\u8BB0");

				Map<String, Object> params = Maps.newHashMapWithExpectedSize(1);
				params.put("code", code);

				req.setSmsParamString(JSON.toJSONString(params));
				req.setRecNum(mobile);
				req.setSmsTemplateCode(TEMPLATE_CODE);
				AlibabaAliqinFcSmsNumSendResponse rsp = client.execute(req);
				logger.info(rsp.getBody());
				
				//解析返回值
				boolean isResult = false;
				String msg = "短信发送错误";
				
				JSONObject object = JSON.parseObject(rsp.getBody());
				JSONObject responseJson = object.getJSONObject("alibaba_aliqin_fc_sms_num_send_response");
				if(responseJson != null) {
					SmsModel smsModel = JSON.parseObject(JSON.toJSONString(responseJson), SmsModel.class);
					if(smsModel != null) {
						isResult = smsModel.getResult().isSuccess();
						msg = smsModel.getResult().getMsg();
					}
				}
				
				if(isResult) {
					msg = "";
				}
				return msg;
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
				return "短信发送异常！" + e.getLocalizedMessage();
			}
		}
		
		return "手机号码不能为空！";
	}
	
	/**
	 * 移动云短信
	 * @param mobile
	 * @param content
	 * @return
	 */
	public static String mascloudSend(String mobile, String content) {
		try {
			
			Calendar calendar = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String nowDatestr = sdf.format(calendar.getTimeInMillis());
			content += nowDatestr; //短信内容后跟个日期时间（可有可无），需求要求

			SendReq sendReq = new SendReq();
			sendReq.setApId(apId);
			sendReq.setEcName(ecName);
			sendReq.setSecretKey(secretKey);
			sendReq.setContent(content);
			sendReq.setMobiles(mobile);
			sendReq.setAddSerial(addSerial);
			sendReq.setSign(sign);

			StringBuffer stringBuffer = new StringBuffer();
			stringBuffer.append(sendReq.getEcName());
			stringBuffer.append(sendReq.getApId());
			stringBuffer.append(sendReq.getSecretKey());
			stringBuffer.append(sendReq.getMobiles());
			stringBuffer.append(sendReq.getContent());
			stringBuffer.append(sendReq.getSign());
			stringBuffer.append(sendReq.getAddSerial());

			sendReq.setMac(MD5(stringBuffer.toString()).toLowerCase());

			String reqText = JSON.toJSONString(sendReq);

			String encode = Base64.encodeBase64String(reqText.getBytes("UTF-8"));
			//System.out.println(encode);

			String resStr = sendPost(normalUrl, encode);

			System.out.println("发送短信结果：" + resStr);

			SendRes sendRes = JSON.parseObject(resStr, SendRes.class);

			if (sendRes.isSuccess() && !"".equals(sendRes.getMsgGroup()) && "success".equals(sendRes.getRspcod())) {
				return "";
			} else {
				return resStr;
			}
			
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			return "短信发送异常！" + e.getLocalizedMessage();
		}
	}

	public static int sendTemplateMsg(String mobiles, String templateId, String params) throws IOException {
		SendReq sendReq = new SendReq();
		sendReq.setApId(apId);
		sendReq.setEcName(ecName);
		sendReq.setSecretKey(secretKey);
		sendReq.setTemplateId(templateId);
		sendReq.setParams(params);
		sendReq.setMobiles(mobiles);
		sendReq.setAddSerial(addSerial);
		sendReq.setSign(sign);

		StringBuffer stringBuffer = new StringBuffer();
		stringBuffer.append(sendReq.getEcName());
		stringBuffer.append(sendReq.getApId());
		stringBuffer.append(sendReq.getSecretKey());
		stringBuffer.append(sendReq.getTemplateId());
		stringBuffer.append(sendReq.getMobiles());
		stringBuffer.append(sendReq.getParams());
		stringBuffer.append(sendReq.getSign());
		stringBuffer.append(sendReq.getAddSerial());

		//System.out.println(stringBuffer.toString());
		sendReq.setMac(MD5(stringBuffer.toString()).toLowerCase());
		//System.out.println(sendReq.getMac());

		String reqText = JSON.toJSONString(sendReq);

		String encode = Base64.encodeBase64String(reqText.getBytes("UTF-8"));
		//System.out.println(encode);

		String resStr = sendPost(templateUrl, encode);

		System.out.println("发送短信结果：" + resStr);

		JSONObject sendRes = JSON.parseObject(resStr);

		if (sendRes.getBoolean("success") && !"".equals(sendRes.getString("msgGroup")) && "success".equals(sendRes.getString("rspcod"))) {
			return 1;
		} else {
			return 0;
		}
	}
	
	/**
	 * 向指定 URL 发送POST方法的请求
	 *
	 * @param url   发送请求的 URL
	 * @param param 请求参数
	 * @return 所代表远程资源的响应结果
	 */
	private static String sendPost(String url, String param) {
		OutputStreamWriter out = null;

		BufferedReader in = null;
		String result = "";
		try {
			java.net.URL realUrl = new java.net.URL(url);
			URLConnection conn = realUrl.openConnection();
			conn.setRequestProperty("accept", "*/*");
			conn.setRequestProperty("contentType", "utf-8");
			conn.setRequestProperty("connection", "Keep-Alive");
			conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
			conn.setDoOutput(true);
			conn.setDoInput(true);

			out = new OutputStreamWriter(conn.getOutputStream());
			out.write(param);
			out.flush();


			in = new BufferedReader(
					new InputStreamReader(conn.getInputStream()));
			String line;
			while ((line = in.readLine()) != null) {
				result += "\n" + line;
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (out != null) {
					out.close();
				}
				if (in != null) {
					in.close();
				}
			} catch (IOException ex) {
				ex.printStackTrace();
			}
		}
		return result;
	}
	
	/**
	 * Md5加密字符串
	 *
	 * @param str
	 * @return
	 */
	public static final String Build(String str) {
		MessageDigest md;
		try {
			md = MessageDigest.getInstance("MD5");
			return byte2hexString(md.digest(str.getBytes()));
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		}
		return "";
	}

	/**
	 * MD5加密调用的方法
	 *
	 * @param bytes
	 * @return
	 * @since 1.1
	 */
	private static final String byte2hexString(byte[] bytes) {
		StringBuffer buf = new StringBuffer(bytes.length * 2);
		for (int i = 0; i < bytes.length; i++) {
			if (((int) bytes[i] & 0xff) < 0x10) {
				buf.append("0");
			}
			buf.append(Long.toString((int) bytes[i] & 0xff, 16));
		}
		return buf.toString();
	}
	
	/**
	 * 生成MD5码
	 *
	 * @param plainText 要加密的字符串
	 * @return md5值
	 */
	public final static String MD5(String plainText) {
		try {
			byte[] strTemp = plainText.getBytes("UTF-8");
			MessageDigest mdTemp = MessageDigest.getInstance("MD5");
			mdTemp.update(strTemp);
			byte[] md = mdTemp.digest();
			int j = md.length;
			char str[] = new char[j * 2];
			int k = 0;
			for (int i = 0; i < j; i++) {
				byte byte0 = md[i];
				str[k++] = hexDigits[byte0 >>> 4 & 0xf];
				str[k++] = hexDigits[byte0 & 0xf];
			}
			return new String(str);
		} catch (Exception e) {
			return null;
		}
	}
	
	static class SendReq {
		private String ecName;        //集团客户名称
		private String apId;        //用户名
		private String secretKey;            //密码
		private String mobiles;        //手机号码逗号分隔。(如“18137282928,18137282922,18137282923”)
		private String content;        //发送短信内容
		private String templateId;        //发送短信模板id
		private String params;        //发送短信模板参数
		private String sign;        //网关签名编码，必填，签名编码在中国移动集团开通帐号后分配，可以在云MAS网页端管理子系统-SMS接口管理功能中下载。
		private String addSerial;            //扩展码，根据向移动公司申请的通道填写，如果申请的精确匹配通道，则填写空字符串("")，否则添加移动公司允许的扩展码。
		private String mac;            //API输入参数签名结果，签名算法：将ecName，apId，secretKey，mobiles，content ，sign，addSerial按照顺序拼接，然后通过md5(32位小写)计算后得出的值。

		public String getEcName() {
			return ecName;
		}

		public void setEcName(String ecName) {
			this.ecName = ecName;
		}

		public String getApId() {
			return apId;
		}

		public void setApId(String apId) {
			this.apId = apId;
		}

		public String getSecretKey() {
			return secretKey;
		}

		public void setSecretKey(String secretKey) {
			this.secretKey = secretKey;
		}

		public String getMobiles() {
			return mobiles;
		}

		public void setMobiles(String mobiles) {
			this.mobiles = mobiles;
		}

		public String getContent() {
			return content;
		}

		public void setContent(String content) {
			this.content = content;
		}

		public String getTemplateId() {
			return templateId;
		}

		public void setTemplateId(String templateId) {
			this.templateId = templateId;
		}

		public String getParams() {
			return params;
		}

		public void setParams(String params) {
			this.params = params;
		}

		public String getSign() {
			return sign;
		}

		public void setSign(String sign) {
			this.sign = sign;
		}

		public String getAddSerial() {
			return addSerial;
		}

		public void setAddSerial(String addSerial) {
			this.addSerial = addSerial;
		}

		public String getMac() {
			return mac;
		}

		public void setMac(String mac) {
			this.mac = mac;
		}
	}

	static class SendRes {
		private String rspcod;    //响应状态码
		private String msgGroup;    //消息批次号，由云MAS平台生成，用于验证短信提交报告和状态报告的一致性（取值msgGroup）注:如果数据验证不通过msgGroup为空
		private boolean success;    //数据校验结果

		public String getRspcod() {
			return rspcod;
		}

		public void setRspcod(String rspcod) {
			this.rspcod = rspcod;
		}

		public String getMsgGroup() {
			return msgGroup;
		}

		public void setMsgGroup(String msgGroup) {
			this.msgGroup = msgGroup;
		}

		public boolean isSuccess() {
			return success;
		}

		public void setSuccess(boolean success) {
			this.success = success;
		}
	}
	
	//main方法测试发送短信，返回1表示成功，0表示失败
	public static void main(String[] args) throws IOException {
		String msg = "这是发送短信的内容！";
		String result = mascloudSend("13775185063", msg);

		//int result = sendTemplateMsg("15961261657", "325d2f82a2ac4093919c5a08fcc7c8b6", "[\"123456\"]");
		//System.out.println("===" + result);
	}
}
