package cn.gtmap.secondaryMarket.common.utils;

import cn.gtmap.secondaryMarket.common.domain.firstmarket.FLTransResource;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * Created by jiff on 15/5/5.
 */
public class ResourceUtils {


    static int beginHour=9;
    static int endHour=17;
    static int min = 0;

    public static FLTransResource buildNewResource(Date ggEndDate){
        beginHour = 8;
        min = 30;
        ggEndDate=addDate(ggEndDate, 1);
        Date beginDate=getDate(ggEndDate, beginHour,min);
        Date endDate=  getDate(addDate(ggEndDate, 11),beginHour,30);
        FLTransResource flTransResource = new FLTransResource();
        flTransResource.setBmBeginTime(beginDate);
        flTransResource.setBmEndTime(getDate(addDate(endDate, -2), 16, 0));
        flTransResource.setGpBeginTime(beginDate);
        flTransResource.setGpEndTime(endDate);
        flTransResource.setBzjBeginTime(beginDate);
        flTransResource.setBzjEndTime(getDate(addDate(endDate, -2), 16, 0));
        flTransResource.setXsBeginTime(endDate);
        flTransResource.setQualificationType("0");
        return flTransResource;
    }

    public static Date getDate(Date date,int hour,int min){
        try {
            DateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            DateFormat df2 = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            String dateStr = df1.format(date) + " " + hour + ":" + min;
            return df2.parse(dateStr);
        }catch (Exception ex){
            return Calendar.getInstance().getTime();
        }
    }

    public static Date addDate(Date date,int days){
        GregorianCalendar gc=new GregorianCalendar();
        gc.setTime(date);
        gc.add(Calendar.DAY_OF_MONTH,days);
        return gc.getTime();
    }

    public static Date addDateMin(Date date,int min){
        GregorianCalendar gc=new GregorianCalendar();
        gc.setTime(date);
        gc.add(Calendar.MINUTE,min);
        return gc.getTime();
    }
}
