package cn.gtmap.secondaryMarket.common.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;

/**
 * object公共方法
 * @author zhujunjie
 * @date 2019-4-4
 */
public class ObjectUtil {

    /**
     * 判断object是否是null如果是null则返回空
     * @param obj
     * @return
     */
    public static Object isNUll(Object obj){
        if(obj == null){
            obj = "";
        }
        return obj;
    }

    /**
     * 循环遍历map将null转换成空
     * @param map
     * @return
     */
    public static Map loopMapNull(Map map){
        if(map != null){
            Iterator entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = (Map.Entry) entries.next();
                Object value = entry.getValue();
                if(value == null){
                    entry.setValue("");
                }
            }
        }
        return map;
    }

    /**
     * 根据编码获取byte[]
     * @param str
     * @param charsetName
     * @return
     */
    public static byte[] getBytes(String str, String charsetName){
        byte[] bytes = null;
        if(str != null){
            try {
                bytes = str.getBytes(charsetName);
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return bytes;
    }

    /**
     * 将object转成string类型
     * @param obj
     * @return
     */
    public static String objToString(Object obj){
        if(obj !=null){
            return obj.toString();
        }
        return null;
    }


    public static BigDecimal objToBigDecimal(Object obj){
        if(obj !=null){
            return new BigDecimal(obj.toString());
        }
        return null;
    }
}
