package cn.gtmap.secondaryMarket.common.utils;

import ch.qos.logback.core.net.SyslogOutputStream;
import cn.gtmap.secondaryMarket.common.utils.DateUtils.DateUtil;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * map与实体类对象的相互转换
 *
 * @author zhujunjie
 */
public class MapUtil {

    /**
     * 将一个 JavaBean 对象转化为一个  Map
     *
     * @param bean 要转化的JavaBean 对象
     * @return 转化出来的  Map 对象
     * @throws IntrospectionException    如果分析类属性失败
     * @throws IllegalAccessException    如果实例化 JavaBean 失败
     * @throws InvocationTargetException 如果调用属性的 setter 方法失败
     */
    public static Map convertBean(Object bean) {
        Class type = bean.getClass();
        Map returnMap = new HashMap();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(type);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; i++) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if (!"class".equals(propertyName)) {
                    Method readMethod = descriptor.getReadMethod();
                    Object result = readMethod.invoke(bean, new Object[0]);
                    if (result != null) {
                        returnMap.put(propertyName, result);
                    } else {
                        returnMap.put(propertyName, "");
                    }
                }
            }
        } catch (IntrospectionException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return returnMap;
    }


    /**
     * 将map转换成实体类对象
     * @param map
     * @param type
     * @return
     */
    public static Object convertMap(Map map, Class type) {
        // 获取类属性
        BeanInfo beanInfo = null;
        // 创建 JavaBean 对象
        Object obj = null;
        try {
            beanInfo = Introspector.getBeanInfo(type);
            obj = type.newInstance();
            // 给 JavaBean 对象的属性赋值
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptors.length; i++) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                String propertyName = descriptor.getName();
                if (map.containsKey(propertyName)) {
                    // 下面一句可以 try 起来，这样当一个属性赋值失败的时候就不会影响其他属性赋值。
                    Object value = map.get(propertyName);
                    if (value != null) {
                        if (descriptor.getPropertyType() == Date.class) {
                            value = DateUtil.String2Date(value.toString(), "yyyy-MM-dd HH:mm:ss");
                        } else if (descriptor.getPropertyType() == Short.class) {
                            value = Short.valueOf(value.toString());
                        } else if (descriptor.getPropertyType() == Integer.class) {
                            value = Integer.valueOf(value.toString());
                        } else if (descriptor.getPropertyType() == Double.class) {
                            value = Double.valueOf(value.toString());
                        } else if (descriptor.getPropertyType() == Long.class) {
                            value = Long.valueOf(value.toString());
                        } else if (descriptor.getPropertyType() == BigDecimal.class) {
                            value = new BigDecimal(value.toString());
                        }
                        Object[] args = new Object[1];
                        args[0] = value;
                        descriptor.getWriteMethod().invoke(obj, args);
                    }
                }
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (IntrospectionException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        }
        return obj;
    }

}

