package cn.gtmap.secondaryMarket.common.utils;

import cn.gtmap.secondaryMarket.common.domain.SysFile;
import cn.gtmap.secondaryMarket.common.domain.fileCenter.Node;
import cn.gtmap.secondaryMarket.common.domain.fileCenter.NodeImpl;
import com.gtis.fileCenter.service.MimeTypeService;
import com.gtis.fileCenter.service.impl.MimeTypeServiceImpl;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @描述 文件中心工具栏
 * @作者 卜祥东
 * @创建日期 2022年1月28日
 * @创建时间 上午11:17:53
 * @版本号 V 1.0
 */
public class FileCenterUtil {
	public static List<Node> getNodeFromSysFile(List<SysFile> sysFileList) {
		List<Node> nodeList = new ArrayList<Node>();
		if (CollectionUtils.isNotEmpty(sysFileList)) {
			for (SysFile sysFile : sysFileList) {
				NodeImpl currentNode = new NodeImpl();
				currentNode.setId(sysFile.getColId());
				currentNode.setName(sysFile.getColFileName());
				currentNode.setParentId(sysFile.getColParentId());
				currentNode.setChildCount(0);
				currentNode.setScope(0);
				currentNode.setType(sysFile.getColFileType());
				currentNode.setUpdateTime(sysFile.getColUploadTime());
				currentNode.setIcon(getIcon(sysFile.getColFileName()));
				nodeList.add(currentNode);
			}
		}
		return nodeList;
	}

	public static Node getNodeFromSysFile(SysFile sysFile, Integer type) {
		NodeImpl currentNode = new NodeImpl();
		currentNode.setId(sysFile.getColId());
		currentNode.setName(sysFile.getColFileName());
		currentNode.setParentId(sysFile.getColParentId());
		currentNode.setChildCount(0);
		currentNode.setScope(0);
		currentNode.setType(type);
		currentNode.setUpdateTime(new Date());
		if (Node.TYPE_NODE == type) {
			currentNode.setIcon("folder.gif");
		} else {
			currentNode.setIcon(getIcon(sysFile.getColFileName()));
		}
		return currentNode;
	}

	public static SysFile getSysFileFromNode(NodeImpl nodeImpl) {
		SysFile folder = new SysFile();
		folder.setColFileKey(nodeImpl.getParentId());
		folder.setColFileName(nodeImpl.getName());
		folder.setColDescription(nodeImpl.getDescription());
		folder.setColUploadTime(nodeImpl.getUpdateTime());
		folder.setColFileType(nodeImpl.getType());
		return folder;
	}

	public static String getIcon(String fileName) {
		MimeTypeService mimeTypeService = new MimeTypeServiceImpl();
		return mimeTypeService.getIcon(fileName);
	}
}
