package cn.gtmap.secondaryMarket.common.utils.ExportUtil;

import cn.gtmap.egovplat.core.util.Charsets;
import freemarker.template.Template;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

import javax.servlet.http.HttpServletResponse;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class ExportUtil {

    @Autowired
    static FreeMarkerConfigurer freeMarkerConfigurer;

    /**
     * 自定义模板导出
     * @param content
     * @param fileName
     * @param dataModel
     * @param response
     * @throws Exception
     */
    public static void customTplResponse(String content, String fileName, Object dataModel, HttpServletResponse response)
            throws Exception {
        OutputStream outputStream = null;
        Writer bufferedWriter = null;
        try {
            response.reset();
            response.setContentType("application/msword; charset=" + Charsets.UTF8);
            response.setHeader("Content-Disposition", "attachment; filename="
                    + new String(fileName.getBytes(Charsets.CHARSET_GBK), Charsets.CHARSET_ISO88591));
            Template template = new Template(fileName, content, freeMarkerConfigurer.getConfiguration());
            outputStream = response.getOutputStream();
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, Charsets.CHARSET_UTF8));
            template.process(dataModel, bufferedWriter);
            outputStream.flush();
        } finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}
