package cn.gtmap.secondaryMarket.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.sql.Blob;

public class DownLoadUtil {
	protected static final Logger logger = LoggerFactory.getLogger(DownLoadUtil.class);

	/**
	 * 描述：下载文件（输出流形式）
	 *
	 * @param request
	 * @param response
	 * @param fileName
	 * @param file
	 * @throws UnsupportedEncodingException
	 * @throws FileNotFoundException
	 * @author 卜祥东
	 * 2018年6月20日 上午9:10:54
	 */
	public static void downloadFile(HttpServletRequest request, HttpServletResponse response,
	                                String fileName, File file) throws UnsupportedEncodingException, FileNotFoundException {
		// 设置输出的格式
		response.reset();
		response.setCharacterEncoding("UTF-8");
		response.setHeader("Content-Disposition", DownLoadUtil.getBrowserContentDisposition(request, fileName));
		response.setContentType("application/octet-stream");
		response.setHeader("Content-Length", String.valueOf(file.length()));// 告诉浏览器下载文件的大小
		InputStream is = new FileInputStream(file);
		OutputStream os = null;
		try {
			os = new BufferedOutputStream(response.getOutputStream());
			is = new BufferedInputStream(is);
			// 创建字节数组缓冲区
			final int SIZE = 1024;
			byte[] buff = new byte[SIZE];
			int len = 0;
			while ((len = is.read(buff)) != -1) {
				os.write(buff, 0, len);
			}
			os.flush();
			logger.info("==========下载完毕！=========");
		} catch (IOException e) {
			logger.error("下载异常=======" + e.getMessage());
		} finally {
			if (is != null) {
				try {
					is.close();
				} catch (IOException ex) {
					logger.error("关闭流异常=======" + ex.getMessage());
				}
			}
			if (os != null) {
				try {
					os.close();
				} catch (IOException ex) {
					logger.error("关闭流异常=======" + ex.getMessage());
				}
			}
		}
	}

	public static void downloadFile(HttpServletRequest request, HttpServletResponse response,
	                                String fileName, InputStream inputStream) throws Exception {
		// 设置输出的格式
		response.reset();
		response.setCharacterEncoding("UTF-8");
		response.setHeader("Content-Disposition", DownLoadUtil.getBrowserContentDisposition(request, fileName));
		response.setContentType("application/octet-stream");
		OutputStream os = null;
		try {
			os = new BufferedOutputStream(response.getOutputStream());
			inputStream = new BufferedInputStream(inputStream);
			// 创建字节数组缓冲区
			final int SIZE = 1024;
			byte[] buff = new byte[SIZE];
			int len = 0;
			while ((len = inputStream.read(buff)) != -1) {
				os.write(buff, 0, len);
			}
			os.flush();
			response.setHeader("Content-Length", String.valueOf(inputStream.available()));// 告诉浏览器下载文件的大小
			logger.info("==========下载完毕！=========");
		} catch (IOException e) {
			logger.error("下载异常=======" + e.getMessage());
		} finally {
			if (inputStream != null) {
				try {
					inputStream.close();
				} catch (IOException ex) {
					logger.error("关闭流异常=======" + ex.getMessage());
				}
			}
			if (os != null) {
				try {
					os.close();
				} catch (IOException ex) {
					logger.error("关闭流异常=======" + ex.getMessage());
				}
			}
		}
	}

	/**
	 * 描述：下载文件Blob（输出流形式）
	 *
	 * @param request
	 * @param response
	 * @param fileName
	 * @param blobFile
	 * @throws UnsupportedEncodingException
	 * @throws FileNotFoundException
	 * @author 卜祥东
	 * 2018年9月27日 下午2:45:38
	 */
	public static void downloadBlobFile(HttpServletRequest request, HttpServletResponse response,
	                                    String fileName, Blob blobFile) throws UnsupportedEncodingException, FileNotFoundException {
		// 设置输出的格式
		response.reset();
		response.setCharacterEncoding("UTF-8");
		response.setHeader("Content-Disposition", DownLoadUtil.getBrowserContentDisposition(request, fileName));
		response.setContentType("application/octet-stream");
		InputStream is = null;
		OutputStream os = null;
		try {
			response.setHeader("Content-Length", String.valueOf(blobFile.length()));// 告诉浏览器下载文件的大小
			is = blobFile.getBinaryStream();
			os = new BufferedOutputStream(response.getOutputStream());
			int len = 0;
			byte[] buff = new byte[((oracle.sql.BLOB) blobFile).getBufferSize()];
			while ((len = is.read(buff)) != -1) {
				os.write(buff, 0, len);
			}
			os.flush();
			logger.info("==========下载完毕！=========");
		} catch (Exception e) {
			logger.error("下载异常=======" + e.getMessage());
		} finally {
			if (os != null) {
				try {
					os.close();
				} catch (IOException ex) {
					logger.error("关闭流异常=======" + ex.getMessage());
				}
			}
			if (is != null) {
				try {
					is.close();
				} catch (IOException ex) {
					logger.error("关闭流异常=======" + ex.getMessage());
				}
			}
		}

	}

	/**
	 * 描述：response.setHeader("Content-Disposition", contentDisposition); 创建人：卜祥东
	 * 创建时间：2015-6-16 下午05:02:18
	 *
	 * @param @param  request
	 * @param @param  downFileName
	 * @param @return
	 * @param @throws UnsupportedEncodingException
	 * @return String
	 */
	public static String getBrowserContentDisposition(HttpServletRequest request, String downFileName) throws UnsupportedEncodingException {
		String browser = getBrowser(request);
		String contentDisposition = "";
		if ("IE".equals(browser)) {
			contentDisposition = "attachment; filename=" + URLEncoder.encode(downFileName, "UTF-8").replace("+", "%20");
		} else if ("SF".equals(browser)) {
			contentDisposition = "attachment; filename=" + new String(downFileName.getBytes("UTF-8"), "ISO8859-1");
		} else {
			contentDisposition = "attachment; filename*=UTF-8''" + URLEncoder.encode(downFileName, "UTF-8").replace("+", "%20");
		}
		return contentDisposition;
	}

	/**
	 * 描述：获取浏览器类型 创建人：卜祥东 创建时间：2015-6-16 下午04:58:24
	 *
	 * @param @param  request
	 * @param @return
	 * @return String
	 */
	public static String getBrowser(HttpServletRequest request) {
		String userAgent = request.getHeader("USER-AGENT").toLowerCase();
		if (userAgent != null) {
			if (userAgent.indexOf("msie") >= 0) {
				return "IE";
			} else if (userAgent.indexOf("mozilla") >= 0) {
				return "FF";
			} else if (userAgent.indexOf("applewebkit") >= 0) {
				return "CH";
			} else if (userAgent.indexOf("safari") >= 0) {
				return "SF";
			} else if (userAgent.indexOf("opera") >= 0) {
				return "OP";
			}
		}
		return null;
	}
}
