package cn.gtmap.secondaryMarket.common.utils.DateUtils;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;

import java.util.Set;

/**
 * 转换工具
 * @author zsj
 * @version v1.0, 2018/5/9
 */
public class ConversionService extends DefaultConversionService implements InitializingBean {
    private Set<Converter> converters;

    public void setConverters(Set<Converter> converters) {
        this.converters = converters;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (converters != null) {
            for (Converter converter : converters) {
                addConverter(converter);
            }
        }
    }
}