package cn.gtmap.secondaryMarket.common.utils;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @文件说明
 * @作者 deery
 * @创建日期 上午 9:58
 * @版本号 V 1.0
 */
public class CommonUtils {

    /**
     * 获得工作流定义中的附件类型(初始化文件中心附件文件夹)
     * @param nodeService
     * @param fileCenterNodeId
     */
    public static void initWorkflowFileCenter(NodeService nodeService,int fileCenterNodeId){
        List<Node> nodeChiles = nodeService.getChildNodes(fileCenterNodeId);
        if (nodeChiles == null || nodeChiles.size() <= 0){
            //获得工作流定义中的附件类型，用于待办任务打开时，初始化待办任务的附件管理页面
            List configList = new ArrayList();
            if (configList != null && configList.size() > 0){
                for (int i = 0; i < configList.size(); i++) {
                    Object configTmp =  configList.get(i);
                    Node stuffNode = nodeService.getNode(fileCenterNodeId,"你的文件夹名称",true);
                }
            }
        }
    }

    /**
      * 获取两个日期相差的月数
      */

    public static int getMonthDiff(Date d1, Date d2) {

        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(Calendar.YEAR);
        int year2 = c2.get(Calendar.YEAR);
        int month1 = c1.get(Calendar.MONTH);
        int month2 = c2.get(Calendar.MONTH);
        int day1 = c1.get(Calendar.DAY_OF_MONTH);
        int day2 = c2.get(Calendar.DAY_OF_MONTH);
        int yearInterval = year1 - year2;
        if (month1 < month2 || month1 == month2 && day1 < day2)
        yearInterval--;
        // 获取月数差值
        int monthInterval = (month1 + 12) - month2;
        if (day1 < day2)
        monthInterval--;
        monthInterval %= 12;
        int monthsDiff = Math.abs(yearInterval * 12 + monthInterval);
        return monthsDiff;
    }

    /**
          * 获取两个日期相差的年数
          */

    public static int getYearDiff(Date d1, Date d2) {

        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(Calendar.YEAR);
        int year2 = c2.get(Calendar.YEAR);
        int yearInterval = year1 - year2;
        return Math.abs(yearInterval);
    }
}
