package cn.gtmap.secondaryMarket.common.utils;

import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * Resource utils
 *
 * @author monarchCheng
 * @create 2017-11-09 18:21
 **/
public class BeanUtil {


    /**
     * copy Bean
     *
     * @param source
     * @param target
     */
    public static void copyBean(Object source, Object target,String...ignores) {
        BeanUtils.copyProperties(source, target,ignores);
    }

    /**
     * copy Bean List
     *
     * @param iterable
     * @param targetClazz
     * @param <T>
     * @return
     */
    public static <T> List<T> copyBeanList(Iterable iterable, Class<T> targetClazz) {
        List<T> newList = new ArrayList<>();
        for (Object o : iterable) {
            try {
                T t = targetClazz.newInstance();
                BeanUtils.copyProperties(o, t);
                newList.add(t);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newList;
    }

    /**
     * copy Bean List
     *
     * @param iterable
     * @return
     */
    public static List<Object> copyBeanList(Iterable iterable) {
        List<Object> newList = new ArrayList<>();
        for (Object o : iterable) {
            try {
                newList.add(o);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newList;
    }


    /**
     * copy bean page
     *
     * @param page
     * @param pageable
     * @param targetClazz
     * @param <T>
     * @return
     */
    public static <T> Page<T> copyBeanPage(Page page, Pageable pageable, Class<T> targetClazz) {
        List<T> newList = copyBeanList(page, targetClazz);
        return new PageImpl(newList, pageable, page.getTotalElements());
    }

    /**
     * copy bean page
     *
     * @param page
     * @param pageable
     * @return
     */
    public static Page<Object> copyBeanPage(Page page, Pageable pageable) {
        List<Object> newList = copyBeanList(page);
        return new PageImpl(newList, pageable, page.getTotalElements());
    }


    /**
     * get ids
     *
     * @param list
     * @param clazz
     * @param methodName
     * @param <T>
     * @return
     */
    public static <T> List<String> getIds(List<T> list, Class clazz, String methodName) {
        List<String> ids = new ArrayList<>(list.size());
        try {
            Method m = clazz.getMethod(methodName);
            for (T t : list) {
                String id = (String) m.invoke(t);
                ids.add(id);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ids;
    }

}
