package cn.gtmap.secondaryMarket.common.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import cn.gtmap.secondaryMarket.common.domain.SysFile;
import cn.gtmap.secondaryMarket.common.domain.TransContractSt;
import cn.gtmap.secondaryMarket.common.domain.fileCenter.Node;
import cn.gtmap.secondaryMarket.common.domain.fileCenter.NodeImpl;
import cn.gtmap.secondaryMarket.common.register.StorageClient;
import cn.gtmap.secondaryMarket.common.utils.DateUtils.DateUtil;

/**
 * @描述 不动产接口工具类
 * @作者 卜祥东
 * @创建日期 2022年1月17日
 * @创建时间 下午4:44:09
 * @版本号 V 1.0
 */
@Component
public class BdcInterfaceUtil {
	private static Logger logger = LoggerFactory.getLogger(BdcInterfaceUtil.class);
	@Autowired
	private StorageClient storageClient;

	/**
	 * 根据不动产单元号获取抵押查封数据
	 *
	 * @return
	 */
	public static String conFirmBdcZh(String url, String bdcdyh) {
		url = url + "/rest/v1.0/interface/ycsl_xzqlbybdcdyh";
		String result = null;
		try {
			result = UrlPostUtil.requestServiceJson(url, "{\"bdcdyh\": \"" + bdcdyh + "\"}");
		} catch (Exception e) {
			result = "{}";
		}

		String data = "";
		JSONObject resultJson = JSON.parseObject(result);
		JSONObject xzxx = resultJson.getJSONObject("xzxx");
		if (xzxx != null) {
			Date now = new Date();
			JSONArray cfxx = xzxx.getJSONArray("cfxx");
			if (CollectionUtils.isNotEmpty(cfxx)) {
				for (Object o : cfxx) {
					String cfjssj = ((JSONObject) o).getString("cfjssj");
					if (StringUtils.isNotBlank(cfjssj)) {
						Date cfjssjDate = DateUtil.String2Date(cfjssj, "yyyy-MM-dd");
						if (cfjssjDate.after(now)) {
							data += "cfxx:" + cfjssj;
							break;
						}
					}
				}
			}
			JSONArray dyxx = xzxx.getJSONArray("dyxx");
			if (CollectionUtils.isNotEmpty(dyxx)) {
				for (Object o : dyxx) {
					String dyjssj = ((JSONObject) o).getString("dyjssj");
					if (StringUtils.isNotBlank(dyjssj)) {
						Date dyjssjDate = DateUtil.String2Date(dyjssj, "yyyy-MM-dd");
						if (dyjssjDate.after(now)) {
							data += "dyxx:" + dyjssj;
							break;
						}
					}
				}
			}
		}
		return data;
	}

	/**
	 * @作者 王建明
	 * @创建日期 2021/12/10 上午9:39
	 * @描述 通过产权证号获取地块附属信息
	 */
	public static List<Object> getLandInfoByCqzh(String url, String cqzh) {
		try {
			url = url + "/rest/v1.0/wwsq/bdczscx";
			Map params = new HashMap();
			Map data = new HashMap();
			data.put("cqzh", cqzh);
			data.put("dyr", "");
			data.put("xzqydm", "");
			data.put("zl", "");
			params.put("data", data);
			String result = UrlPostUtil.requestServiceJson(url, JSON.toJSONString(params));
			if (StringUtils.isNotBlank(result)) {
				JSONArray jsonData = ((JSONObject) JSON.parseObject(result)).getJSONArray("data");
				if (CollectionUtils.isNotEmpty(jsonData)) {
					return JSON.parseArray(jsonData.toJSONString(), Object.class);
				}
			}
			return null;
		} catch (Exception e) {
			logger.error("", e);
			return null;
		}
	}

	/**
	 * 描述：获取个人不动产数据-通过身份证号
	 * 
	 * @author 卜祥东 2022年1月17日 下午4:46:09
	 * @param url
	 * @param sfzh 身份证号
	 * @param xm   姓名
	 * @return
	 */
	public static List<Object> getWwsqCqzxxFy(String url, String xm, String sfzh) {
		try {
			url = url + "/rest/v1.0/wwsqinterface/getWwsqCqzxxFy";
			Map<String, Object> params = new HashMap<String, Object>();
			
			Map<String, Object> params_data = new HashMap<String, Object>();
			params_data.put("gxrzjh", sfzh);
			params_data.put("gxrmc", xm);
			params_data.put("cqzh", "");
			params_data.put("zl", "");
			params_data.put("bdcdyh", "");
			params.put("data", params_data);
			
			Map<String, Object> params_head = new HashMap<String, Object>();
			params_head.put("orgid", "");
			params_head.put("regionCode", "");
			params.put("head", params_head);
			
			Map<String, Object> params_pageInfo = new HashMap<String, Object>();
			params_pageInfo.put("pageSize", "50");
			params_pageInfo.put("pageNumber", "0");
			params.put("pageInfo", params_pageInfo);
			
			String result = UrlPostUtil.requestServiceJson(url, JSON.toJSONString(params));
			if (StringUtils.isNotBlank(result)) {
				JSONArray jsonData = ((JSONObject) JSON.parseObject(result)).getJSONArray("cqxx");
				if (CollectionUtils.isNotEmpty(jsonData)) {
					return JSON.parseArray(jsonData.toJSONString(), Object.class);
				}
			}
			return null;
		} catch (Exception e) {
			logger.error("", e);
			return null;
		}
	}

	/**
	 * 描述：送合同数据到不动产系统
	 * @author 卜祥东
	 * 2022年1月19日 上午10:52:56
	 * @param url
	 * @param transContractSt
	 * @param fileCenterUrl
	 * @return
	 */
	public void pushContractStToBdc(String url, TransContractSt transContractSt,String bdcSqlx,String adminUrl) {
		try {
			url = url + "/rest/v2.0/wwsq/initWwsqxxAndFj";
			Map<String, Object> params = new HashMap<String, Object>();
			Map<String, Object> params_head = new HashMap<String, Object>();
			params_head.put("orgid", "");
			params_head.put("regionCode", "");
			params.put("head", params_head);
//			合同信息表字段包括：
//			受让方基本信息（名称、证件类型、证件号码、联系电话、代理人、代理人身份证号）
//			地块信息（坐落、不动产单元号、不动产权证号、登记面积）
//			其他（合同编号、合同签订日期、交易价格、付款方式名称）
//			创建人角色名称
			//数据
			Map<String, Object> params_data = new HashMap<String, Object>();
			params_data.put("ywh", UuidUtil.createUuid());
			//不动产类型
			if("TD".equals(transContractSt.getBdclx())) {
				params_data.put("sqdjlx", "215");
			}else {
				params_data.put("sqdjlx", bdcSqlx);
			}
			params_data.put("cjrjsmc", "连云港二级市场推送");

			//数据-不动产单元信息
			List<Map<String, Object>> params_data_bdcdyxxList = new ArrayList<Map<String, Object>>();
			Map<String, Object> params_data_bdcdyxx = new HashMap<String, Object>();
			params_data_bdcdyxx.put("mj", String.valueOf(transContractSt.getdTddjmj()));//房屋面积
			params_data_bdcdyxx.put("bdcdyh", transContractSt.getdBdcdyh());//不动产单元号
			params_data_bdcdyxx.put("zl", transContractSt.getdTdzl());//坐落
			params_data_bdcdyxx.put("tdzh", transContractSt.getdBdcqszh());//土地证号
			//数据-不动产单元信息-产权信息
			params_data_bdcdyxx.put("cqxx", setBdcdyxxCqxx(transContractSt));// 数组
			
			//数据-不动产单元信息-附件
			params_data_bdcdyxx.put("fjxx", setBdcdyxxFjxx(transContractSt,adminUrl));// 数组
			
			params_data_bdcdyxxList.add(params_data_bdcdyxx);
			params_data.put("bdcdyxx", params_data_bdcdyxxList);// 数组
			
			params.put("data", params_data);
			UrlPostUtil.requestServiceJson(url, JSON.toJSONString(params));
		} catch (Exception e) {
			logger.error("", e);
		}
	}

	private static List<Map<String, Object>> setBdcdyxxCqxx(TransContractSt transContractSt) {
		//数据-不动产单元信息-产权信息
		List<Map<String, Object>> params_data_bdcdyxx_cqxxList = new ArrayList<Map<String, Object>>();
		Map<String, Object> params_data_bdcdyxx_cqxx = new HashMap<String, Object>();
		params_data_bdcdyxx_cqxx.put("htbh", transContractSt.getContractNo());//合同编号
		params_data_bdcdyxx_cqxx.put("htqdrq",
				DateUtil.formateDateString("yyyy-MM-dd", transContractSt.getdQdsj()));//合同签订日期
		params_data_bdcdyxx_cqxx.put("jyjg", String.valueOf(transContractSt.getdZrzjk()));//交易价格
		params_data_bdcdyxx_cqxx.put("fkfsmc", transContractSt.getDfkfs());//付款方式名称

		//数据-不动产单元信息-产权信息-权利人信息
		List<Map<String, Object>> params_data_bdcdyxx_cqxx_qlrxxList = new ArrayList<Map<String, Object>>();
		Map<String, Object> params_data_bdcdyxx_cqxx_qlrxx = new HashMap<String, Object>();
		params_data_bdcdyxx_cqxx_qlrxx.put("qlrdlr", transContractSt.getjWtdkr());//权利人代理人
		params_data_bdcdyxx_cqxx_qlrxx.put("qlrdlrzjh", transContractSt.getjWtdkrSfzh());//权利人代理人证件号
		params_data_bdcdyxx_cqxx_qlrxx.put("qlrmc", transContractSt.getjZrf());//权利人名称
		params_data_bdcdyxx_cqxx_qlrxx.put("qlrsfzjzl", transContractSt.getjZjlx());//权利人身份证件种类
		params_data_bdcdyxx_cqxx_qlrxx.put("qlrzjh", transContractSt.getjZjlx());//权利人证件号
		params_data_bdcdyxx_cqxx_qlrxx.put("qlrlxdh", transContractSt.getjLxdh());//联系电话
		params_data_bdcdyxx_cqxx_qlrxxList.add(params_data_bdcdyxx_cqxx_qlrxx);
		params_data_bdcdyxx_cqxx.put("qlrxx", params_data_bdcdyxx_cqxx_qlrxxList);// 数组

		params_data_bdcdyxx_cqxxList.add(params_data_bdcdyxx_cqxx);
		return params_data_bdcdyxx_cqxxList;
	}

	private List<Map<String, Object>> setBdcdyxxFjxx(TransContractSt transContractSt,String adminUrl) {
		List<Map<String, Object>> params_data_bdcdyxx_fjxxList = new ArrayList<Map<String, Object>>();
		String fileKey = transContractSt.getRelationId();
		if (StringUtils.isNotBlank(fileKey)) {
			fileKey = transContractSt.getId();
		}
		List<SysFile> sysFiles = storageClient.getSysFileList(fileKey,Node.TYPE_NODE);
		List<Node> childNodeList = FileCenterUtil.getNodeFromSysFile(sysFiles);
		if(CollectionUtils.isNotEmpty(childNodeList)) {
			for (Node childNode : childNodeList) {
				((NodeImpl)childNode).setChildCount(storageClient.getCountByParentId(childNode.getId()));
				Map<String, Object> params_data_bdcdyxx_fjxx = new HashMap<String, Object>();
				params_data_bdcdyxx_fjxx.put("clmc", childNode.getName());//材料名称
				params_data_bdcdyxx_fjxx.put("ys", String.valueOf(childNode.getChildCount()));//页数
				params_data_bdcdyxx_fjxx.put("mrfjys", String.valueOf(childNode.getChildCount()));//默认附件页数
				params_data_bdcdyxx_fjxx.put("fs", String.valueOf(childNode.getChildCount()));//份数
				params_data_bdcdyxx_fjxx.put("fjlx", childNode.getDescription());//附件类型
				
				List<Map<String, Object>> params_data_bdcdyxx_fjxxList_clnrList = new ArrayList<Map<String, Object>>();
				if(childNode.getChildCount()>0) {
					List<SysFile> childFiles = storageClient.getListByParentId(childNode.getId());
					List<Node> childNodeChildList = FileCenterUtil.getNodeFromSysFile(childFiles);
					if(CollectionUtils.isNotEmpty(childNodeChildList)) {
						for (Node childNodeChild : childNodeChildList) {
							Map<String, Object> params_data_bdcdyxx_fjxxList_clnr = new HashMap<String, Object>();
							params_data_bdcdyxx_fjxxList_clnr.put("fjid", String.valueOf(childNodeChild.getId()));//附件id
							params_data_bdcdyxx_fjxxList_clnr.put("fjmc", childNodeChild.getName());//附件名称
							params_data_bdcdyxx_fjxxList_clnr.put("fjurl", adminUrl + "/admin/fcm/file/get.do?fid=" + childNodeChild.getId());//附件地址
							params_data_bdcdyxx_fjxxList_clnr.put("bytes", "");//Byte内容
							params_data_bdcdyxx_fjxxList_clnrList.add(params_data_bdcdyxx_fjxxList_clnr);
						}
					}
				}
				//不动产单元号信息-附件-材料内容		
				params_data_bdcdyxx_fjxx.put("clnr", params_data_bdcdyxx_fjxxList_clnrList);//材料内容
				
				params_data_bdcdyxx_fjxxList.add(params_data_bdcdyxx_fjxx);
			}
		}
		return params_data_bdcdyxx_fjxxList;
	}

}
