package cn.gtmap.secondaryMarket.common.utils;

import com.alibaba.fastjson.JSONObject;
import org.dom4j.Document;
import org.dom4j.Element;

public class BankXmlUtil {

    /**
     * 解析银行返回来的报文
     * @param receiveXml
     * @return
     */
    public static JSONObject getXmlJson(String receiveXml){
        //交易码
        String aucTrxCode = receiveXml.substring(0,6);
        //报文方向
        String aucMsgType = receiveXml.substring(6,7);
        //交易发起时间
        String aucReqTime = receiveXml.substring(7,21);
        //交易流水号
        String aucFlwNo = receiveXml.substring(21,29);
        String xmlString = receiveXml.substring(29,receiveXml.length());
        JSONObject jsonObject = Xml2JsonUtil.xml2JSON(xmlString).getJSONObject("ebank");
        jsonObject.put("aucTrxCode",aucTrxCode);
        jsonObject.put("aucMsgType",aucMsgType);
        jsonObject.put("aucReqTime",aucReqTime);
        jsonObject.put("aucFlwNo",aucFlwNo);
        return jsonObject;
    }

    /**
     * 根据路径获取值
     * @param doc
     * @param path
     * @return
     */
    public String getElementValue(Document doc, String path){
        Element element=(Element) doc.selectSingleNode(path);
        if (element!=null){
            return element.getTextTrim();
        }else{
            return null;
        }
    }
}
