package cn.gtmap.secondaryMarket.common.security;

import cn.gtmap.secondaryMarket.common.domain.TransRole;
import cn.gtmap.secondaryMarket.common.domain.TransUser;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.WebUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 用户登录信息 处理
 * @author zsj
 * @version v1.0, 2018/5/14
 */
public class SecUtil {

    /**
     * session信息
     */
    final static String USER_KEY = "USER_KEY";
    final static String USER_ID_KEY = "USER_ID_KEY";
    final static String USER_ROLE_KEY = "USER_ROLE_KEY";

    /**
     * 判断是否登录
     * @param request
     * @return
     */
    public static boolean isLogin(HttpServletRequest request){
        return StringUtils.isNoneBlank(getLoginUserIdToSession(request));
    }

    /**
     * 获取登录角色
     * @param request
     * @return
     */
    public static List<TransRole> getLoginRoleToSession(HttpServletRequest request){
        return (List<TransRole>) WebUtils.getSessionAttribute(request, USER_ROLE_KEY);
    }

    /**
     * 获取登录用户
     * @param request
     * @return
     */
    public static TransUser getLoginUserToSession(HttpServletRequest request){
        return (TransUser) WebUtils.getSessionAttribute(request, USER_KEY);
    }

    /**
     * 获取登录用户ID
     * @param request
     * @return
     */
    public static String getLoginUserIdToSession(HttpServletRequest request){
        return (String) WebUtils.getSessionAttribute(request, USER_ID_KEY);
    }

    /**
     * 登录
     * @param request
     * @param transUser
     * @param transRole
     */
    public static void login4Session(HttpServletRequest request, TransUser transUser, List<TransRole> transRoles){
        setLoginUserToSession(request, transUser);
        setLoginUserIdToSession(request, transUser);
        setLoginRoleToSession(request, transRoles);
    }

    /**
     * 登出
     * @param request
     */
    public static void logout4Session(HttpServletRequest request){
        setLoginUserToSession(request, null);
        setLoginUserIdToSession(request, null);
        setLoginRoleToSession(request, null);
    }

    public static void setLoginRoleToSession(HttpServletRequest request, List<TransRole> transRoles){
        WebUtils.setSessionAttribute(request, USER_ROLE_KEY, transRoles);
    }

    public static void setLoginUserToSession(HttpServletRequest request, TransUser transUser){
        WebUtils.setSessionAttribute(request, USER_KEY, transUser);
    }

    public static void setLoginUserIdToSession(HttpServletRequest request, TransUser transUser){
        if (transUser != null) {
            WebUtils.setSessionAttribute(request, USER_ID_KEY, transUser.getUserId());
        } else {
            WebUtils.setSessionAttribute(request, USER_ID_KEY, null);
        }
    }

}
