package cn.gtmap.secondaryMarket.common.security;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;

/**
 * 登录拦截器
 * @author zsj
 * @version v1.0, 2018/5/14
 */
public class SecContextInterceptor implements HandlerInterceptor {
    private String[] excludes;
    private String[] needLogins;
    private String redirectUrl;
    protected UrlPathHelper urlPathHelper = RequestUtils.URL_PATH_HELPER;
    protected PathMatcher pathMatcher = RequestUtils.PATH_MATCHER;

    private String[] strArr = {"\"", "%", "--", "create", "drop", "delete", "update", "insert", "union", "alert", "iframe", "script"};

    public void setNeedLogins(String[] needLogins) {
        this.needLogins = needLogins;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        if (!RequestUtils.matchAny(request, urlPathHelper, pathMatcher, excludes)) {
            boolean login= SecUtil.isLogin(request);
            String XRequested =request.getHeader("X-Requested-With");
            if (RequestUtils.matchAny(request, urlPathHelper, pathMatcher, needLogins)) {
            	
                //获取单点登录用户名
                String userNameParam = request.getParameter("singleUserName");
                if(!StringUtils.isEmpty(userNameParam)) {
                    response.setCharacterEncoding("UTF-8");
                    response.setHeader("Content-type", "text/html;charset=UTF-8");
                    PrintWriter out = response.getWriter();
                    StringBuffer str = new StringBuffer();
                    str.append("<script type=\"text/javascript\">");
                    str.append("window.top.location.href='");
                    str.append(redirectUrl + (redirectUrl.contains("?") ? "&" : "?") + request.getQueryString());
                    str.append("';");
                    str.append("</script>");
                    out.print(str.toString());
                    
                    return false;
                }
                
                 //将登录的session里面的userid放入线程
                if (redirectUrl != null && !login) {
                    if("XMLHttpRequest".equalsIgnoreCase(XRequested)){
                        //todo 如果是ajax请求
                        response.setHeader("REDIRECT","REDIRECT");
                        //告诉ajax我重定向的路径
                        response.setHeader("CONTENTPATH", redirectUrl + (redirectUrl.contains("?") ? "&" : "?") + "url=" + checkUrl(ServletUriComponentsBuilder.fromRequest(request).build().encode().toString()));
                        response.setStatus(HttpServletResponse.SC_FORBIDDEN);
                    }else{
                        response.setCharacterEncoding("UTF-8");
                        response.setHeader("Content-type", "text/html;charset=UTF-8");
                        PrintWriter out = response.getWriter();
                        StringBuffer str = new StringBuffer();
                        str.append("<script type=\"text/javascript\">");
                        str.append("alert('请先登录！');");
                        str.append("window.top.location.href='");
                        str.append(redirectUrl + (redirectUrl.contains("?") ? "&" : "?") + "url=" + checkUrl(ServletUriComponentsBuilder.fromRequest(request).build().encode().toString()));
                        str.append("';");
                        str.append("</script>");
                        out.print(str.toString());
                    }
                } else {
                    return true;
                }
                return false;
            }
        }
        return true;
    }


    private String checkUrl(String redirectUrl) {
        for (String arr : strArr) {
            if (redirectUrl.contains(arr)) {
                redirectUrl = redirectUrl.replace(arr, "");
            }
        }
        return redirectUrl;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
        if (RequestUtils.matchAny(request, urlPathHelper, pathMatcher, excludes)) {
            SecurityContext.clearContext();
        }
    }
}