package cn.gtmap.secondaryMarket.common.register.trade;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Map;

/**
 * 银行接口方法
 * @author zhujunjie
 */
@FeignClient(name = "bank-server")
public interface TransBankInterfaceClient {

    /**
     * ac001
     * 向银行发送保证金开户申请
     * @param map
     * @return
     */
    @RequestMapping(value = "/bankInterface/sendBankApplyAccount", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage sendBankApplyAccount(@RequestBody Map map);

    /**
     * ac002
     * 模拟银行发送存入保证金验证
     * @param map
     * @return
     */
    @RequestMapping(value = "/bankInterfaceTest/sendBzjConfirm", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage sendBzjConfirm(@RequestBody Map map);


    /**
     * ac003
     * 向银行发送保证金账户余额查询
     * @param map
     * @return
     */
    @RequestMapping(value = "/bankInterface/sendBzjBalance", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage sendBzjBalance(@RequestBody Map map);


    /**
     * ac004
     * 向银行发送保证金账户解密
     * @param map
     * @return
     */
    @RequestMapping(value = "/bankInterface/sendBzjDecrypt", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage sendBzjDecrypt(@RequestBody Map map);


    /**
     * auc005
     * 模拟银行发送保证金存款确认
     * @param map
     * @return
     */
    @RequestMapping(value = "/bankInterfaceTest/sendBzjDepositSubmit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage sendBzjDepositSubmit(@RequestBody Map map);


    /**
     * auc006
     * 向银行发送撤销保证金账号
     * @param map
     * @return
     */
    @RequestMapping(value = "/bankInterface/sendBzjRevoke", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage sendBzjRevoke(@RequestBody Map map);


    /**
     * auc999
     * 测试链路
     * @param map
     * @return
     */
    @RequestMapping(value = "/bankInterfaceTest/sendTestXml", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage sendTestXml(@RequestBody Map map);
}
