package cn.gtmap.secondaryMarket.common.register.trade;

import cn.gtmap.egovplat.core.data.Page;
import cn.gtmap.egovplat.core.data.Pageable;
import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.firstmarket.TransBankConfig;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 银行配置服务方法
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransBankConfigClient {

    /**
     * 获取银行配置 分页
     * @param bankName
     * @param page
     * @return
     */
    @RequestMapping(value = "/bankConfig/getTransBankConfigPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransBankConfig> getTransBankConfigPage(@RequestParam(value="bankName",required = false) String bankName,
                                                         @RequestBody PageRequest page);

    /**
     * 获取 银行配置列表
     * @return
     */
    @RequestMapping(value = "/bankConfig/getTransBankConfigList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransBankConfig> getTransBankConfigList();

    /**
     * 通过银行配置ID 获取银行配置信息
     * @param configId
     * @return
     */
    @RequestMapping(value = "/bankConfig/getTransBankConfigById", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransBankConfig getTransBankConfigById(@RequestParam(value = "configId") String configId);

    /**
     * 添加 银行配置信息
     * @param transBankConfig
     * @return
     */
    @RequestMapping(value = "/bankConfig/addTransBankConfig", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransBankConfig> addTransBankConfig(@RequestBody TransBankConfig transBankConfig);

    /**
     * 修改 银行配置信息
     * @param transBankConfig
     * @return
     */
    @RequestMapping(value = "/bankConfig/updateTransBankConfig", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransBankConfig> updateTransBankConfig(@RequestBody TransBankConfig transBankConfig);

    /**
     * 删除 银行配置信息
     * @param configId
     * @return
     */
    @RequestMapping(value = "/bankConfig/deleteTransBankConfig", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteTransBankConfig(@RequestParam(value = "configId") String configId);

    /**
     * 批量删除数据
     * @param configIds
     * @return
     */
    @RequestMapping(value = "/bankConfig/deleteByConfigs", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByConfigs(@RequestParam(value="configIds") String[] configIds);
}
