package cn.gtmap.secondaryMarket.common.register.trade;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.firstmarket.TransBank;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = "core-server")
public interface TransBankClient {

    /**
     * 获取银行 分页服务
     * @param regionCodes 所属行政区
     * @param page
     * @param bankName
     * @return
     */
    @RequestMapping(value = "/bank/findBankPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransBank> findBankPage(@RequestParam(value="bankName", required = false) String bankName,
                                         @RequestParam(value="regionCodes", required = false) List regionCodes,
                                         @RequestBody PageRequest page);

    @RequestMapping(value = "/bank/getBankList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransBank> getBankList();

    @RequestMapping(value = "/bank/getBank", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransBank getBank(@RequestParam(value="bankId") String bankId);

    @RequestMapping(value = "/bank/getBankListByRegion", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransBank> getBankListByRegion(@RequestParam(value="regionCode") String regionCode);

    @RequestMapping(value = "/bank/saveTransBank", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransBank> saveTransBank(@RequestBody TransBank transBank);

    @RequestMapping(value = "/bank/updateTransBank", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransBank> updateTransBank(@RequestBody TransBank transBank);

    @RequestMapping(value = "/bank/deleteBank", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransBank> deleteBank(@RequestParam(value="bankId") String bankId);

    @RequestMapping(value = "/bank/getBankByCodeAndRegion", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransBank getBankByCodeAndRegion(@RequestParam(value="bankCode", required = false) String bankCode,
                                     @RequestParam(value="regionCode", required = false) String regionCode);

    @RequestMapping(value = "/bank/findByCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransBank findByCode(@RequestParam(value="code", required = false) String code);


    @RequestMapping(value = "/bank/deleteByBankIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByBankIds(@RequestParam(value="bankIds") String[] bankIds);

}
