package cn.gtmap.secondaryMarket.common.register.trade;

import cn.gtmap.secondaryMarket.common.domain.firstmarket.FLTransResource;
import cn.gtmap.secondaryMarket.common.domain.form.BankPayForm;
import cn.gtmap.secondaryMarket.common.domain.form.BaoZhengJinSearchVo;
import cn.gtmap.secondaryMarket.common.domain.form.FLTransResourceForm;
import cn.gtmap.secondaryMarket.common.domain.vo.BankPayVo;
import cn.gtmap.secondaryMarket.common.domain.vo.BaoZhengJinDetailVo;
import cn.gtmap.secondaryMarket.common.domain.vo.FLTransResourceAndBZJVo;
import cn.gtmap.secondaryMarket.common.domain.vo.FLTransResourceVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * 一级市场地块服务
 * @author: zhujunjie
 * @date: 2019/4/24
 **/
@FeignClient(name = "core-server")
public interface FLTransResourceClient {
    @RequestMapping(value = "/fLTransResource/findTransResource", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    Map findTransResource(@RequestParam("resourceId") String resourceId);

    /**
     * 分页查询
     * @return
     */
    @RequestMapping(value = "/fLTransResource/findTransResourcePage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<FLTransResourceVo> findTransResourcePage(@RequestBody FLTransResourceForm form);

    @RequestMapping(value = "/fLTransResource/findBaoZhengJinListPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<FLTransResourceVo> findBaoZhengJinListPage(@RequestBody FLTransResourceForm form);

    @RequestMapping(value = "/fLTransResource/findBaoZhengJinDetailInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    BaoZhengJinDetailVo findBaoZhengJinDetailInfo(@RequestBody BaoZhengJinSearchVo baoZhengJinSearchVo);

    @RequestMapping(value = "/fLTransResource/findBankPayList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<BankPayVo> findBankPayList(@RequestBody BankPayForm bankPayForm);

    @RequestMapping(value = "/fLTransResource/findTransResourceAndBZJPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<FLTransResourceAndBZJVo> findTransResourceAndBZJPage(@RequestBody FLTransResourceForm form);

    @RequestMapping(value = "/fLTransResource/findTransResourceAndBZJDetail", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<FLTransResourceAndBZJVo> findTransResourceAndBZJDetail(@RequestBody FLTransResourceForm form);
}
