package cn.gtmap.secondaryMarket.common.register.trade;


import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.secondaryMarket.common.constants.FLConstants;
import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.firstmarket.CaSignerX;

import java.util.HashMap;

/**
 * CA数字证书SVS签名验证服务
 * @author zsj
 * @version v1.0, 2017/10/18
 */
@FeignClient(name = "core-server")
public interface CaSvsClient {

    /**
     * 验证证书是否有效
     * @param certificate 所需要验证的证书（B64编码）
     * @return
     */
    @RequestMapping(value = "/caSvs/validateCertificate", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage validateCertificate(@RequestParam(value = "certificate") String certificate);

    /**
     * 验证PKCS1签名是否正确
     * @param certificate 签名证书（B64编码）
     * @param signature 签名数据(B64编码)
     * @param data 原文数据((B64编码)
     * @param algo 签名算法
     * @param dataType 原文数据类型
     * @return
     */
    @RequestMapping(value = "/caSvs/validatePKCS1Signature", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage validatePKCS1Signature(@RequestParam("certificate") String certificate, @RequestParam("signature") String signature, @RequestParam("data") String data, @RequestParam("algo") String algo, @RequestBody FLConstants.CaOriginalDateType dataType);

    /**
     * 验证PKCS7签名是否正确
     * @param p7data PKCS7格式数据(B64编码)。注意：该pkcs7数据中应包含签名证书(链)、签名数据以及原文数据
     * @return
     */
    @RequestMapping(value = "/caSvs/validatePKCS7Signature", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage validatePKCS7Signature(@RequestParam(value = "p7data") String p7data);

    @RequestMapping(value = "/caSvs/caSignatureValidation", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage caSignatureValidation(@RequestBody CaSignerX caSignerX, @RequestParam(value = "decodeBase64")boolean decodeBase64);

    @RequestMapping(value = "/caSvs/validateGxcaPKCS1Signature", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage validateGxcaPKCS1Signature(@RequestBody CaSignerX caSignerX, @RequestParam(value = "decodeBase64")boolean decodeBase64);

    @RequestMapping(value = "/caSvs/gxcaPreLoginData", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    HashMap<String,String> gxcaPreLoginData(@RequestParam(value = "cert") String cert);

}
