package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.vo.HisInstanceVo;
import cn.gtmap.secondaryMarket.common.domain.vo.TaskCommentVo;
import cn.gtmap.secondaryMarket.common.domain.vo.TaskVo;
import cn.gtmap.secondaryMarket.common.domain.workflow.Task;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * 工作流服务（调用core提供的）
 * @author zhujunjie
 * @date 2018-5-17 10:15:36
 */
@FeignClient(name = "core-server")
public interface WorkFlowClient {

    /**
     * 查询待办列表
     * @param pageRequest
     * @param assignee 经办人
     * @param publishLandType 类型
     * @param holderName 权利人
     * @return
     */
    @RequestMapping(value = "/workflow/findTaskVoPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TaskVo> findTaskVoPage(@RequestBody PageRequest pageRequest, @RequestParam(value = "assignee") String assignee, @RequestParam(value = "holderName", required = false) String holderName,
                                        @RequestParam(value = "publishLandType", required = false) BigDecimal publishLandType);

    /**
     * 查询已办列表
     * @param pageRequest
     * @param userId 用户id
     * @param holderName 权利人
     * @param publishLandType 土地类型
     * @return
     */
    @RequestMapping(value = "/workflow/findHistoricProcessInstancePage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<HisInstanceVo> findHistoricProcessInstancePage(@RequestBody PageRequest pageRequest, @RequestParam(value = "userId") String userId, @RequestParam(value = "holderName", required = false) String holderName,
                                                                @RequestParam(value = "publishLandType", required = false) BigDecimal publishLandType);

    /**
     * 查询流程任务批注
     * @param processinstanceId 流程实例id
     * @return
     */
    @RequestMapping(value = "/workflow/findTaskCommentList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TaskCommentVo> findTaskCommentList(@RequestParam(value = "processinstanceId") String processinstanceId);

    /**
     * 根据流程实例id来查询任务对象
     * @param processInstanceId
     * @return
     */
    @RequestMapping(value = "/workflow/findTaskCommentList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public Task getTaskByProcessInstanceId(@RequestParam(value = "processInstanceId") String processInstanceId);

    /**
     * 根据processinstanceId查询task对象
     * @param processinstanceId
     * @return
     */
    @RequestMapping(value = "/workflow/getTaskVoByProcessinstanceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public TaskVo getTaskVoByProcessinstanceId(@RequestParam(value = "processinstanceId") String processinstanceId);

    /**
     * 根据procInstId和userName获取历史task对象
     * @param procInstId
     * @param userName
     * @return
     */
    @RequestMapping(value = "/workflow/findHisTaskVoList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public List<TaskVo> findHisTaskVoList(@RequestParam(value = "procInstId", required = false) String procInstId, @RequestParam(value = "userName", required = false) String userName);
}
