package cn.gtmap.secondaryMarket.common.register;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;

/**
 * @描述 联合竞买分页服务
 * @作者 卜祥东
 * @创建日期 2022年2月8日
 * @创建时间 下午4:32:55
 * @版本号 V 1.0
 */
@FeignClient(name = "core-server")
public interface TransUserUnionClient {

	/**
	 * 列表
	 * 
	 * @param pageRequest
	 * @param resourceId
	 * @return
	 */
	@RequestMapping(value = "/union/findTransUserUnionByUserName", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	PageResponse findTransUserUnionByUserName(@RequestParam(value = "userName", required = false) String userName,
			@RequestBody PageRequest pageRequest);

}
