package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransUser;
import cn.gtmap.secondaryMarket.common.domain.vo.TransUserRoleVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 用户服务
 * @author zsj
 * @version v1.0, 2018/5/12
 */
@FeignClient(name = "core-server")
public interface TransUserClient {
	
	 /**
     * 获取用户
     * @param userName
     * @param thumbprint
     * @return
     */
    @RequestMapping(value = "/user/getTransUserByKeyInfo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransUser getTransUserByKeyInfo(@RequestParam("userName") String userName ,@RequestParam("thumbprint") String thumbprint);

    /**
     * 获取用户对象
     * @param userId
     * @return
     */
    @RequestMapping(value = "/user/selectTransUserById", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransUser selectTransUserById(@RequestParam(value="userId") String userId);

    /**
     * 删除用户 通过Id
     * @param userId
     * @return
     */
    @RequestMapping(value = "/user/deleteTransUserById", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteTransUserById(@RequestParam(value="userId") String userId);

    /**
     * 删除用户 通过Ids
     * @param userIds
     * @return
     */
    @RequestMapping(value = "/user/deleteTransUserByIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteTransUserByIds(@RequestParam(value="userIds") String userIds);

    /**
     * 添加用户
     * @param transUser
     * @return
     */
    @RequestMapping(value = "/user/saveTransUser", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransUser> saveTransUser(@RequestBody TransUser transUser);

    /**
     * 添加用户角色
     * @param transUser
     * @param roleId
     * @return
     */
    @RequestMapping(value = "/user/saveTransUserAndRole", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransUser> saveTransUserAndRole(@RequestBody TransUser transUser, @RequestParam(value="roleId") String roleId);

    /**
     * 修改用户 增量
     * @param transUser
     * @return
     */
    @RequestMapping(value = "/user/updateTransUserSelective", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransUser> updateTransUserSelective(@RequestBody TransUser transUser);

    /**
     * 修改用户 角色 增量
     * @param transUser
     * @param roleId
     * @return
     */
    @RequestMapping(value = "/user/updateTransUserRoleSelective", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransUser> updateTransUserRoleSelective(@RequestBody TransUser transUser, @RequestParam(value="roleId") String roleId);

    /**
     * 修改用户 全量
     * @param transUser
     * @return
     */
    @RequestMapping(value = "/user/updateTransUser", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransUser> updateTransUser(@RequestBody TransUser transUser);

    /**
     * 验证用户
     * @param userName
     * @param password
     * @return
     */
    @RequestMapping(value = "/user/validateTransUser", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransUser validateTransUser(@RequestParam(value="userName") String userName, @RequestParam(value="password") String password);

    /**
     * 列表
     * @param pageRequest
     * @param userName
     * @return
     */
    @RequestMapping(value = "/user/findTransUserPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransUser> findTransUserPage(@RequestBody PageRequest pageRequest, @RequestParam(value = "userName", required = false) String userName);

    /**
     * 分页查询 用户角色Vo
     * @param pageRequest
     * @param userName
     * @return
     */
    @RequestMapping(value = "/user/findTransUserRoleVoPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransUserRoleVo> findTransUserRoleVoPage(@RequestBody PageRequest pageRequest, @RequestParam(value = "userName", required = false) String userName,@RequestParam(value = "type", required = true) Short type);

    /**
     * 查询 用户角色Vo
     * @param userId
     * @return
     */
    @RequestMapping(value = "/user/selectTransUserRoleVoById", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransUserRoleVo selectTransUserRoleVoById(@RequestParam(value = "userId", required = false) String userId, @RequestParam(value = "roleId", required = false) String roleId);

    /**
     * 根据roleName获取用逗号拼接userName字符串
     * @param roleName
     * @return
     */
    @RequestMapping(value = "/user/selectUserNamesByRleName", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    String selectUserNamesByRleName(@RequestParam(value="roleName") String roleName);

    /**
     * 根据条件来查询用户list集合
     * @param userName
     * @param mobile
     * @return
     */
    @RequestMapping(value = "/user/selectUserByConditions", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public List<TransUser> selectUserByConditions(@RequestParam(value="userName",required = false) String userName, @RequestParam(value="mobile",required = false) String mobile);

    /**
     *
     * @param roleName
     * @return
     */
    @RequestMapping(value = "/user/selectUserIdsByRleName", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public String selectUserIdsByRleName(@RequestParam(value="roleName") String roleName, @RequestParam(value="regionCode", required = false) String regionCode);

}
