package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransBlock;
import cn.gtmap.secondaryMarket.common.domain.TransTdytLog;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 土地用途日志服务
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransTdytLogClient {

    /**
     * 保存方法
     * @param transBlock
     * @return
     */
    @RequestMapping(value = "/tdytLog/save", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage save(@RequestBody TransBlock transBlock);

    /**
     * 根绝blockId删除数据
     * @param blockId
     * @return
     */
    @RequestMapping(value = "/tdytLog/deleteByBlockId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByBlockId(@RequestParam(value="blockId") String blockId);

    /**
     * 根绝resourceId删除数据
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/tdytLog/deleteByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByResourceId(@RequestParam(value="resourceId") String resourceId);

    /**
     * 根据resourceId查询用逗号拼接的土地用途名称
     * @param resourceId
     * @param tdytType
     * @return
     */
    @RequestMapping(value = "/tdytLog/getNameByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    String getNameByResourceId(@RequestParam(value="resourceId") String resourceId, @RequestParam(value="tdytType") Integer tdytType);
}
