package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransRoleMenu;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 角色菜单服务
 * @author zsj
 * @version v1.0, 2018/5/22
 */
@FeignClient(name = "core-server")
public interface TransRoleMenuClient {

    /**
     * 添加角色菜单
     * @return
     */
    @RequestMapping(value = "/roleMenu/addRoleMenu", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage addRoleMenu(@RequestParam(value="roleId", required = false) String roleId, @RequestParam(value="menuIds", required = false) String menuIds);

    /**
     * 获取角色菜单
     * @param roleMenuId
     * @param roleId
     * @param menuId
     * @return
     */
    @RequestMapping(value = "/roleMenu/selectRoleMenuList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransRoleMenu> selectRoleMenuList(@RequestParam(value="roleMenuId", required = false) String roleMenuId, @RequestParam(value="roleId", required = false) String roleId, @RequestParam(value="menuId", required = false) String menuId);

    /**
     * 根据roleId获取用逗号拼接menuId字符串
     * @param roleId
     * @return
     */
    @RequestMapping(value = "/roleMenu/selectMenuIdByRoleId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    String selectMenuIdByRoleId(@RequestParam(value="roleId")String roleId);
}
