package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransRole;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 角色管理
 * @author zww
 * @version v1.0, 2018/5/3
 */
@FeignClient(name = "core-server")
public interface TransRoleClient {

    /**
     * 列表
     * @param pageRequest
     * @param roleName
     * @return
     */
    @RequestMapping(value = "/role/findTransRolePage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransRole> findTransRolePage(@RequestBody PageRequest pageRequest, @RequestParam(value = "roleName", required = false) String roleName);

    /**
     * 获取所有角色列表
     * @return
     */
    @RequestMapping(value = "/role/findTransRoleList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransRole> findTransRoleList();

    /**
     * 通过用户 获取角色
     * @param userId
     * @return
     */
    @RequestMapping(value = "/role/selectTransRolebyUser", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransRole> selectTransRolebyUser(@RequestParam(value = "userId") String userId);

    /**
     * 添加方法
     * @param transRole
     * @return
     */
    @RequestMapping(value = "/role/addTransRole", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransRole> addTransRole(@RequestBody TransRole transRole);

    /**
     * 删除
     * @param roleId
     * @return
     */
    @RequestMapping(value = "/role/deleteTransRole", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransRole> deleteTransRole(@RequestParam(value = "roleId") String roleId);

    /**
     * 批量删除
     * @param roleIds
     * @return
     */
    @RequestMapping(value = "/role/deleteTransRoles", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransRole> deleteTransRoles(@RequestParam(value = "roleIds") String roleIds);

    /**
     * 根据主键查询
     * @param roleId
     * @return
     */
    @RequestMapping(value = "/role/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransRole selectByPrimaryKey(@RequestParam(value = "roleId") String roleId);


    /**
     * 修改操作
     * @param record
     * @return
     */
    @RequestMapping(value = "/role/updateTransRole", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransRole> updateTransRole(@RequestBody TransRole record);

}

