package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TongJi;
import cn.gtmap.secondaryMarket.common.domain.TransResource;
import cn.gtmap.secondaryMarket.common.domain.vo.FormVo;
import cn.gtmap.secondaryMarket.common.domain.vo.LandVo;
import cn.gtmap.secondaryMarket.common.domain.vo.SplitLandVo;
import cn.gtmap.secondaryMarket.common.domain.vo.TransResourceVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 土地信息服务
 *
 * @author zhujunjie
 * @version v1.0, 2018/5/4
 */
@FeignClient(name = "core-server")
public interface TransResourceClient {

	/**
	 * 新增
	 *
	 * @param transResource
	 * @return
	 */
	@RequestMapping(value = "/resource/saveResource", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	ResponseMessage<TransResource> saveResource(@RequestBody TransResource transResource);

	/**
	 * 修改
	 *
	 * @param transResource
	 * @return
	 */
	@RequestMapping(value = "/resource/updateResource", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	ResponseMessage<TransResource> updateResource(@RequestBody TransResource transResource);

	/**
	 * 根据id删除数据
	 *
	 * @param resourceId
	 * @return
	 */
	@RequestMapping(value = "/resource/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	ResponseMessage<TransResource> deleteByPrimaryKey(@RequestParam(value = "resourceId") String resourceId);

	/**
	 * 分页查询
	 *
	 * @param form
	 * @return
	 */
	@RequestMapping(value = "/resource/findResourcePage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	PageResponse<TransResourceVo> findResourcePage(@RequestBody FormVo form);


	/**
	 * 根据条件查询list集合
	 *
	 * @param form
	 * @return
	 */
	@RequestMapping(value = "/resource/findListByConditions", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	List<TransResourceVo> findListByConditions(@RequestBody FormVo form);

	/**
	 * 根据id获取对象
	 *
	 * @param resourceId
	 * @return
	 */
	@RequestMapping(value = "/resource/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	TransResource selectByPrimaryKey(@RequestParam(value = "resourceId") String resourceId);

	/**
	 * 删除地块信息和土地信息
	 *
	 * @param resourceIds
	 * @param type        0代表转让 1出租 2抵押 3需求
	 * @return
	 */
	@RequestMapping(value = "/resource/deleteLandResourceByResourceIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	ResponseMessage deleteLandResourceByResourceIds(@RequestParam(value = "resourceIds") String[] resourceIds, @RequestParam(value = "type") int type);

	/**
	 * 根据流程实例id获取实体
	 *
	 * @param processInstanceId
	 * @return
	 */
	@RequestMapping(value = "/resource/getByProcessInstanceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	TransResource getByProcessInstanceId(@RequestParam(value = "processInstanceId") String processInstanceId);

	/**
	 * 根据resourceId数组来改变导出状态
	 *
	 * @param processinstanceIds
	 * @param exportStatus
	 * @return
	 */
	@RequestMapping(value = "/resource/setExport", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	ResponseMessage setExport(@RequestParam(value = "processinstanceIds") String[] processinstanceIds, @RequestParam(value = "exportStatus") BigDecimal exportStatus);


	/**
	 * 根据resourceId数组来改变推介状态
	 *
	 * @param resourceIds
	 * @param isIntroduction
	 * @return
	 */
	@RequestMapping(value = "/resource/setIntroduction", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	ResponseMessage setIntroduction(@RequestParam(value = "resourceIds") String[] resourceIds, @RequestParam(value = "isIntroduction") BigDecimal isIntroduction);

	/**
	 * 根据拼接的resourceId用in语句来查询
	 *
	 * @param resourceIds
	 * @return
	 */
	@RequestMapping(value = "/resource/selectAuditedListByIds", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	public List<TransResource> selectAuditedListByIds(@RequestParam(value = "resourceIds") List resourceIds);


	/**
	 * 查询近几年统计数据
	 * several表示近several年
	 *
	 * @param several
	 * @return
	 */
	@RequestMapping(value = "/resource/getStatisticByData", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	List<TongJi> getStatisticByData(@RequestParam(value = "publishLandType", required = false) Integer publishLandType,
	                                @RequestParam(value = "several") int several);


	/**
	 * 根据行政区来进行统计
	 *
	 * @param regionCode
	 * @param regionLevel
	 * @return
	 */
	@RequestMapping(value = "/resource/getStatisticByCity", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	List<TongJi> getStatisticByCity(@RequestParam(value = "publishLandType", required = false) Integer publishLandType,
	                                @RequestParam(value = "regionCode", required = false) String regionCode,
	                                @RequestParam(value = "regionLevel", required = false) Integer regionLevel,
	                                @RequestParam(value = "currentDate", required = false) String currentDate);


	/**
	 * 根据resourceId查询TransResourceVo实体
	 *
	 * @param resourceId
	 * @return
	 */
	@RequestMapping(value = "/resource/getResourceVo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	TransResourceVo getResourceVo(@RequestParam(value = "resourceId") String resourceId, @RequestParam(value = "taskId",required = false) String taskId);


	/**
	 * 根据土地用途进行查询地块信息
	 *
	 * @param formVo
	 * @return
	 */
	@RequestMapping(value = "/resource/findTransferPageByTdlb", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	PageResponse<LandVo> findTransferPageByTdlb(@RequestBody FormVo formVo);

	@RequestMapping(value = "/resource/findTransferPageDataByTdlb", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	PageResponse<TransResourceVo> findTransferPageDataByTdlb(@RequestBody FormVo formVo);

	/**
	 * 获取多地块vo信息
	 *
	 * @param resourceId
	 * @param landType
	 * @return
	 */
	@RequestMapping(value = "/resource/getSplitLandVo", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	SplitLandVo getSplitLandVo(@RequestParam(value = "resourceId") String resourceId,
	                           @RequestParam(value = "landType") int landType);
	
    /**
     * 获取接口待更新数据
     * @return
     */
    @RequestMapping(value = "/resource/getTransResourceUpList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransResource> getTransResourceUpList(@RequestParam(value="netType",required = false) Integer netType, @RequestParam(value="displayStatus",required = false) Integer displayStatus, @RequestParam(value="publishStatus",required = false) Integer publishStatus);

    /**
     * 查询最大流水号
     * @return
     */
    @RequestMapping(value = "/resource/selectMaxLsh", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    BigDecimal selectMaxLsh();

	/**
	 * 分页查询联合查询
	 *
	 * @param form
	 * @return
	 */
	@RequestMapping(value = "/resource/findResourcePageToContractSt", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
	PageResponse<TransResourceVo> findResourcePageToContractSt(@RequestBody FormVo form);
}
