package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransResourceBuy;
import cn.gtmap.secondaryMarket.common.domain.vo.TransresourceBuyVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

/**
 * 预约信息服务
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransResourceBuyClient {



    /**
     * 根据主键查询
     * @param buyId
     * @return
     */
    @RequestMapping(value = "/resourceBuy/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public TransResourceBuy selectByPrimaryKey(@RequestParam(value="buyId") String buyId);


    /**
     * 根据主键删除
     * @param buyId
     * @return
     */
    @RequestMapping(value = "/resourceBuy/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage deleteByPrimaryKey(@RequestParam(value="buyId") String buyId);


    /**
     * 保存
     * @param transResourceBuy
     * @return
     */
    @RequestMapping(value = "/resourceBuy/addTransResourceBuy", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransResourceBuy> addTransResourceBuy(@RequestBody TransResourceBuy transResourceBuy);


    /**
     * 修改
     * @param transResourceBuy
     * @return
     */
    @RequestMapping(value = "/resourceBuy/updateTransResourceBuy", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransResourceBuy> updateTransResourceBuy(@RequestBody TransResourceBuy transResourceBuy);


    /**
     * 根据resourceId查询小于等于当前日期的
     * 最新记录信息
     * @param resourceId
     * @param date
     * @param userId
     * @return
     */
    @RequestMapping(value = "/resourceBuy/getByResourceIdAndDate", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public TransResourceBuy getByResourceIdAndDate(@RequestParam(value="resourceId") String resourceId, @RequestParam(value="date",required = false) String date,
                                                   @RequestParam(value="userId",required = false) String userId);

    /**
     * 查询列表
     * @param pageRequest
     * @param linkMan
     * @param linkPhone
     * @param linkAddress
     * @param isTop
     * @return
     */
    @RequestMapping(value = "/resourceBuy/findTransResourceBuyPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransresourceBuyVo> findTransResourceBuyPage(@RequestBody PageRequest pageRequest, @RequestParam(value = "linkMan", required = false) String linkMan,
                                                              @RequestParam(value = "linkPhone", required = false) String linkPhone,
                                                              @RequestParam(value = "linkAddress", required = false) String linkAddress,
                                                              @RequestParam(value = "isTop", required = false) BigDecimal isTop,
                                                              @RequestParam(value = "userId", required = false) String userId,
                                                              @RequestParam(value = "publishLandType", required = false) Integer publishLandType);


    /**
     * 根据条件查询list集合
     * @param resourceId
     * @param userId
     * @return
     */
    @RequestMapping(value = "/resourceBuy/findListByStr", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransresourceBuyVo> findListByStr(@RequestParam(value = "resourceId", required = false) String resourceId,
                                           @RequestParam(value = "userId", required = false) String userId);


    /**
     * 根据resourceId批量删除
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/resourceBuy/deleteByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByResourceId(@RequestParam(value = "resourceId") String resourceId);
}
