package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.TransRegion;
import cn.gtmap.secondaryMarket.common.utils.db.Page;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 行政区服务
 * @author zsj
 * @version v1.0, 2018/5/3
 */
@FeignClient(name = "core-server")
public interface TransRegionClient {

    /**
     * 列表
     * @param pageRequest
     * @param regionName
     * @return
     */
    @RequestMapping(value = "/region/findTransRegionPage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    Page<TransRegion> findTransRegionPage(@RequestBody PageRequest pageRequest, @RequestParam(value = "regionName", required = false) String regionName);


    /**
     * 根据条件查询行政区list集合
     * @param regionCode 行政区编码
     * @param regionLevel 等级
     * @param fregionCode 父类编码
     * @return
     */
    @RequestMapping(value = "/region/findTransRegionList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    List<TransRegion> findTransRegionList(@RequestParam(value = "regionCode", required = false) String regionCode,
                                          @RequestParam(value = "regionLevel", required = false) Short regionLevel, @RequestParam(value = "fregionCode", required = false) String fregionCode);

    /**
     * 根据行政区编码获取实体信息
     * @param regionCode
     * @return
     */
    @RequestMapping(value = "/region/getTransRegionByRegionCode", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransRegion getTransRegionByRegionCode(@RequestParam(value = "regionCode") String regionCode);
}
