package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransRecordNumber;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 备案服务
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransRecordNumberClient {

    /**
     * 保存方法
     * @param transRecordNumber
     * @return
     */
    @RequestMapping(value = "/recordNumber/insert", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransRecordNumber> insert(TransRecordNumber transRecordNumber);

    /**
     * 根据id查询实体类
     * @param recordNumberId
     * @return
     */
    @RequestMapping(value = "/recordNumber/selectByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public TransRecordNumber selectByPrimaryKey(@RequestParam(value="recordNumberId") String recordNumberId);


    /**
     * 根据备案号来查询实体
     * @param recordNumber
     * @return
     */
    @RequestMapping(value = "/recordNumber/selectByRecordNumber", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public TransRecordNumber selectByRecordNumber(@RequestParam(value="recordNumber") String recordNumber);


    /**
     * 根据resourceId查询备案表数据
     * @param resourceId
     * @return
     */
    @RequestMapping(value = "/recordNumber/getByResourceId", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public TransRecordNumber getByResourceId(@RequestParam(value="resourceId") String resourceId);
}
