package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransRecordLog;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 备案日志服务
 * @author zhujunjie
 */
@FeignClient(name = "core-server")
public interface TransRecordLogClient {

    /**
     * 保存方法
     * @param transRecordLog
     * @return
     */
    @RequestMapping(value = "/recordLog/saveRecordLog", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public ResponseMessage<TransRecordLog> saveRecordLog(@RequestBody TransRecordLog transRecordLog);

    /**
     * 获取收件单号
     * @return
     */
    @RequestMapping(value = "/recordLog/getRecordNumber", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    public String getRecordNumber();
}
