package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransPicture;
import cn.gtmap.secondaryMarket.common.utils.db.PageRequest;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 菜单服务
 * @author zsj
 * @version v1.0, 2018/5/3
 */
@FeignClient(name = "core-server")
public interface TransPictureManageClient {

    /**
     * 列表页
     * @param pageRequest
     * @param picEnable
     * @return
     */
    @RequestMapping(value = "/picmanage/findTransPicturePage", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransPicture> findTransPicturePage(@RequestBody PageRequest pageRequest, @RequestParam(value = "picEnable", required = false) String picEnable);


    /**
     * 添加方法
     * @param transPicture
     * @return
     */
    @RequestMapping(value = "/picmanage/addTransPicture", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransPicture> addTransPicture(@RequestBody TransPicture transPicture);

    /**
     * 修改方法
     * @param transPicture
     * @return
     */
    @RequestMapping(value = "/picmanage/updateTransPicture", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransPicture> updateTransPicture(@RequestBody TransPicture transPicture);

    /**
     * 启用、禁用
     * @param pictureId
     * @return
     */
    @RequestMapping(value = "/picmanage/audit", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransPicture> updateById(@RequestParam(value = "picEnable") String picEnable, @RequestParam(value = "pictureId") String pictureId);

    /**
     * 根据id查询实体信息
     * @param pictureId
     * @return
     */
    @RequestMapping(value = "/picmanage/selectTransPicture", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransPicture selectTransPicture(@RequestParam(value = "pictureId") String pictureId);

    /**
     * location
     * @param location
     * @return
     */
    @RequestMapping(value = "/picmanage/findByLocation", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransPicture findByLocation(@RequestParam(value = "location") String location);

    /**
     * 根据数组id批量删除数据
     * @param pictureIds
     * @return
     */
    @RequestMapping(value = "/picmanage/deletePictures", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deletePictures(@RequestParam(value = "pictureIds")String[] pictureIds);
}

