package cn.gtmap.secondaryMarket.common.register;

import cn.gtmap.secondaryMarket.common.domain.ResponseMessage;
import cn.gtmap.secondaryMarket.common.domain.TransOrganization;
import cn.gtmap.secondaryMarket.common.domain.vo.FormVo;
import cn.gtmap.secondaryMarket.common.utils.db.PageResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 中介机构服务
 * @author cxm
 * @version v1.0, 2018/7/11
 */
@FeignClient(name = "core-server")
public interface TransOrganizationClient {
    /**
     * 列表页
     * @param formVo
     * @return
     */
    @RequestMapping(value = "/organization/findOrganization", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    PageResponse<TransOrganization> findOrganization(@RequestBody FormVo formVo);

    /**
     * 添加方法
     * @param organization
     * @return
     */
    @RequestMapping(value = "/organization/addOrganization", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransOrganization> addOrganization(@RequestBody TransOrganization organization);

    /**
     * 修改方法
     * @param organization
     * @return
     */
    @RequestMapping(value = "/organization/updateOrganization", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage<TransOrganization> updateOrganization(@RequestBody TransOrganization organization);

    /**
     * 删除方法
     * @param organizationId
     * @return
     */
    @RequestMapping(value = "/organization/deleteByPrimaryKey", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKey(@RequestParam(value = "organizationId") String organizationId);

    /**
     * 根据id数组来删除
     * @param organizationIds
     * @return
     */
    @RequestMapping(value = "/organization/deleteByPrimaryKeys", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    ResponseMessage deleteByPrimaryKeys(@RequestParam(value = "organizationIds") String[] organizationIds);

    /**
     * 根据id查询实体信息
     * @param organizationId
     * @return
     */
    @RequestMapping(value = "/organization/getOrganization", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_VALUE, consumes = MediaType.APPLICATION_JSON_VALUE)
    TransOrganization getOrganization(@RequestParam(value = "organizationId") String organizationId);


}
